/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.google.common.io.Closer;
import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class Alluxio
implements AutoCloseable {
    private static final String IMAGE_NAME = "alluxio/alluxio:2.9.5";
    private static final DockerImageName ALLUXIO_IMAGE = DockerImageName.parse((String)"alluxio/alluxio:2.9.5");
    private final Closer closer = Closer.create();
    private final GenericContainer<?> alluxioMaster = Alluxio.createAlluxioMasterContainer();
    private final GenericContainer<?> alluxioWorker = Alluxio.createAlluxioWorkerContainer();

    public Alluxio() {
        this.closer.register(() -> this.alluxioWorker.close());
        this.closer.register(() -> this.alluxioMaster.close());
    }

    public void start() {
        this.alluxioMaster.start();
        this.alluxioWorker.start();
    }

    @Override
    public void close() throws Exception {
        this.closer.close();
    }

    private static GenericContainer<?> createAlluxioMasterContainer() {
        return new GenericContainer(ALLUXIO_IMAGE).withCommand("master-only").withEnv("ALLUXIO_JAVA_OPTS", "-Dalluxio.security.authentication.type=NOSASL -Dalluxio.master.hostname=localhost -Dalluxio.worker.hostname=localhost -Dalluxio.master.mount.table.root.ufs=/opt/alluxio/underFSStorage -Dalluxio.master.journal.type=NOOP -Dalluxio.security.authorization.permission.enabled=false -Dalluxio.security.authorization.plugins.enabled=false ").withNetworkMode("host").withAccessToHost(true).withStartupAttempts(10).withStartupTimeout(Duration.ofMinutes(10L)).waitingFor(new LogMessageWaitStrategy().withRegEx(".*Primary started*\n").withStartupTimeout(Duration.ofMinutes(3L)));
    }

    private static GenericContainer<?> createAlluxioWorkerContainer() {
        return new GenericContainer(ALLUXIO_IMAGE).withCommand("worker-only").withNetworkMode("host").withEnv("ALLUXIO_JAVA_OPTS", "-Dalluxio.security.authentication.type=NOSASL -Dalluxio.worker.ramdisk.size=512MB -Dalluxio.worker.hostname=localhost -Dalluxio.worker.tieredstore.level0.alias=HDD -Dalluxio.worker.tieredstore.level0.dirs.path=/tmp -Dalluxio.master.hostname=localhost -Dalluxio.security.authorization.permission.enabled=false -Dalluxio.security.authorization.plugins.enabled=false ").withAccessToHost(true).withStartupAttempts(10).withStartupTimeout(Duration.ofMinutes(10L)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Alluxio worker started.*\n", (int)1));
    }
}

