/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers.junit;

import com.github.dockerjava.api.DockerClient;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.testing.services.junit.Listeners;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.testcontainers.DockerClientFactory;

public final class ReportLeakedContainers {
    private static final Logger log = Logger.get(ReportLeakedContainers.class);
    private static final boolean DISABLED = Boolean.getBoolean("ReportLeakedContainers.disabled");
    private static final Set<String> ignoredIds = Collections.synchronizedSet(new HashSet());

    private ReportLeakedContainers() {
    }

    public static void ignoreContainerId(String containerId) {
        ignoredIds.add(Objects.requireNonNull(containerId, "containerId is null"));
    }

    public static class Listener
    implements TestExecutionListener {
        public void testPlanExecutionFinished(TestPlan testPlan) {
            if (DISABLED) {
                log.info("ReportLeakedContainers disabled");
                return;
            }
            try {
                if (ignoredIds.isEmpty()) {
                    Field instanceField = DockerClientFactory.class.getDeclaredField("instance");
                    instanceField.setAccessible(true);
                    if (instanceField.get(null) == null) {
                        log.info("DockerClientFactory not initialized, so there should be no leaked containers, skipping the check");
                        return;
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            log.info("Checking for leaked containers");
            DockerClient dockerClient = DockerClientFactory.lazyClient();
            List containers = (List)((List)dockerClient.listContainersCmd().withLabelFilter(Map.of(DockerClientFactory.TESTCONTAINERS_SESSION_ID_LABEL, DockerClientFactory.SESSION_ID)).withStatusFilter(List.of("created", "restarting", "running", "paused")).exec()).stream().filter(container -> !container.getImage().startsWith("testcontainers/sshd:")).filter(container -> !ignoredIds.contains(container.getId())).collect(ImmutableList.toImmutableList());
            if (!containers.isEmpty()) {
                Listeners.reportListenerFailure(this.getClass(), (String)"Leaked containers: %s", (Object[])new Object[]{containers.stream().map(container -> MoreObjects.toStringHelper((String)"container").add("id", (Object)container.getId()).add("image", (Object)container.getImage()).add("imageId", (Object)container.getImageId()).toString()).collect(Collectors.joining(", ", "[", "]"))});
            }
        }
    }
}

