/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.trino.testing.containers.BaseTestContainer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.Network;

public class KeyManagementServer
extends BaseTestContainer {
    public static final int KES_PORT = 7373;
    private static final Logger log = Logger.get(KeyManagementServer.class);
    private static final String DEFAULT_IMAGE = "minio/kes:2024-06-17T15-47-05Z";
    private static final String DEFAULT_HOST_NAME = "kes";

    public static Builder builder() {
        return new Builder();
    }

    protected KeyManagementServer(String image, String hostName, Set<Integer> ports, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int startupRetryLimit) {
        super(image, hostName, ports, filesToMount, envVars, network, startupRetryLimit);
    }

    @Override
    protected void setupContainer() {
        super.setupContainer();
        this.copyResourceToContainer("kms/config.yml", "/config.yml");
        this.copyResourceToContainer("kms/kms.key", "/kms.key");
        this.copyResourceToContainer("kms/kms.crt", "/kms.crt");
        this.withRunCommand((List<String>)ImmutableList.of((Object)"server", (Object)"--config", (Object)"config.yml"));
    }

    @Override
    public void start() {
        super.start();
        log.info("KMS (MinIO KES) container started with address: https://%s", new Object[]{this.getMappedHostAndPortForExposedPort(7373)});
    }

    public String getMinioKesEndpointURL() {
        return "https://%s:%s".formatted(DEFAULT_HOST_NAME, 7373);
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, KeyManagementServer> {
        private Builder() {
            this.image = KeyManagementServer.DEFAULT_IMAGE;
            this.hostName = KeyManagementServer.DEFAULT_HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)7373);
        }

        @Override
        public KeyManagementServer build() {
            return new KeyManagementServer(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

