/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers.ldap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.testing.containers.ldap.LdapObjectDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;

public final class LdapUtil {
    public static final String MEMBER = "member";

    private LdapUtil() {
    }

    public static String addLdapDefinition(LdapObjectDefinition ldapObjectDefinition, DirContext context) {
        Objects.requireNonNull(ldapObjectDefinition, "LDAP Object Definition is null");
        BasicAttributes entries = new BasicAttributes();
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        ldapObjectDefinition.getAttributes().forEach((key, value) -> entries.put(new BasicAttribute((String)key, value)));
        ldapObjectDefinition.getObjectClasses().forEach(objectClass::add);
        entries.put(objectClass);
        try {
            context.createSubcontext(ldapObjectDefinition.getDistinguishedName(), (Attributes)entries);
        }
        catch (NamingException e) {
            throw new RuntimeException("LDAP Entry addition failed", e);
        }
        return ldapObjectDefinition.getDistinguishedName();
    }

    public static void addAttributesToExistingLdapObjects(String distinguishedName, Map<String, List<String>> modifiedAttributes, DirContext context) {
        Objects.requireNonNull(distinguishedName, "distinguishedName is null");
        Objects.requireNonNull(modifiedAttributes, "modifiedAttributes is null");
        ModificationItem[] modificationItems = (ModificationItem[])modifiedAttributes.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(attribute -> new ModificationItem(1, new BasicAttribute((String)entry.getKey(), attribute)))).toArray(ModificationItem[]::new);
        try {
            context.modifyAttributes(distinguishedName, modificationItems);
        }
        catch (NamingException e) {
            throw new RuntimeException("LDAP Entry updation failed", e);
        }
    }

    public static LdapObjectDefinition buildLdapOrganizationObject(String name, String baseDistinguisedName) {
        return LdapObjectDefinition.builder(name).setDistinguishedName(String.format("ou=%s,%s", name, baseDistinguisedName)).setAttributes((Map<String, String>)ImmutableMap.of((Object)"ou", (Object)name)).setObjectClasses((List<String>)ImmutableList.of((Object)"top", (Object)"organizationalUnit")).build();
    }

    public static LdapObjectDefinition buildLdapGroupObject(String organizationName, String groupName) {
        return LdapObjectDefinition.builder(groupName).setDistinguishedName(String.format("cn=%s,%s", groupName, organizationName)).setAttributes((Map<String, String>)ImmutableMap.of((Object)"cn", (Object)groupName, (Object)MEMBER, (Object)String.format("uid=default-%s,%s", groupName, organizationName))).setObjectClasses((List<String>)ImmutableList.of((Object)"groupOfNames")).build();
    }

    public static LdapObjectDefinition buildLdapUserObject(String organizationName, String userName, String password) {
        return LdapObjectDefinition.builder(userName).setDistinguishedName(String.format("uid=%s,%s", userName, organizationName)).setAttributes((Map<String, String>)ImmutableMap.of((Object)"cn", (Object)userName, (Object)"sn", (Object)userName, (Object)"userPassword", (Object)password)).setObjectClasses(Arrays.asList("person", "inetOrgPerson")).build();
    }
}

