/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingProperties;
import io.trino.testing.containers.ldap.LdapObjectDefinition;
import io.trino.testing.containers.ldap.LdapUtil;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.startupcheck.IsRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class TestingOpenLdapServer
implements Closeable {
    private static final String BASE_DISTINGUISED_NAME = "dc=trino,dc=testldap,dc=com";
    public static final int LDAP_PORT = 389;
    private final Closer closer = Closer.create();
    private final GenericContainer<?> openLdapServer;

    public TestingOpenLdapServer(Network network) {
        this.openLdapServer = new GenericContainer("ghcr.io/trinodb/testing/almalinux9-oj17-openldap:" + TestingProperties.getDockerImagesVersion()).withNetwork(network).withExposedPorts(new Integer[]{389}).withStartupCheckStrategy((StartupCheckStrategy)new IsRunningStartupCheckStrategy()).waitingFor((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(Duration.ofMinutes(5L));
        this.closer.register(() -> this.openLdapServer.close());
    }

    public void start() {
        this.openLdapServer.start();
    }

    public String getNetworkAlias() {
        return (String)this.openLdapServer.getNetworkAliases().get(0);
    }

    public String getLdapUrl() {
        return String.format("ldap://%s:%s", this.openLdapServer.getHost(), this.openLdapServer.getMappedPort(389));
    }

    public DisposableSubContext createOrganization() throws NamingException {
        return this.createOrganization("organization_" + TestingNames.randomNameSuffix());
    }

    public DisposableSubContext createOrganization(String name) throws NamingException {
        return this.createOrganization(name, new DisposableSubContext(BASE_DISTINGUISED_NAME));
    }

    public DisposableSubContext createOrganization(String name, DisposableSubContext subOrganization) throws NamingException {
        return this.createDisposableSubContext(LdapUtil.buildLdapOrganizationObject(name, subOrganization.getDistinguishedName()));
    }

    public DisposableSubContext createGroup(DisposableSubContext organization) throws Exception {
        return this.createGroup(organization, "group_" + TestingNames.randomNameSuffix());
    }

    public DisposableSubContext createGroup(DisposableSubContext organization, String name) throws Exception {
        return this.createDisposableSubContext(LdapUtil.buildLdapGroupObject(organization.getDistinguishedName(), name));
    }

    public DisposableSubContext createUser(DisposableSubContext organization, String userName, String password) throws Exception {
        return this.createDisposableSubContext(LdapUtil.buildLdapUserObject(organization.getDistinguishedName(), userName, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisposableSubContext createDisposableSubContext(LdapObjectDefinition ldapObjectDefinition) throws NamingException {
        try (DirContext context = this.createContext();){
            DisposableSubContext disposableSubContext = new DisposableSubContext(LdapUtil.addLdapDefinition(ldapObjectDefinition, context));
            return disposableSubContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToGroup(DisposableSubContext userDistinguishedName, DisposableSubContext groupDistinguishedName) throws Exception {
        try (DirContext context = this.createContext();){
            LdapUtil.addAttributesToExistingLdapObjects(groupDistinguishedName.getDistinguishedName(), (Map<String, List<String>>)ImmutableMap.of((Object)"member", (Object)ImmutableList.of((Object)userDistinguishedName.getDistinguishedName())), context);
        }
    }

    private DirContext createContext() {
        ImmutableMap environment = ImmutableMap.builder().put((Object)"java.naming.factory.initial", (Object)"com.sun.jndi.ldap.LdapCtxFactory").put((Object)"java.naming.provider.url", (Object)this.getLdapUrl()).put((Object)"java.naming.security.authentication", (Object)"simple").put((Object)"java.naming.security.principal", (Object)"cn=admin,dc=trino,dc=testldap,dc=com").put((Object)"java.naming.security.credentials", (Object)"admin").buildOrThrow();
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)environment);
            return new InitialDirContext(properties);
        }
        catch (NamingException e) {
            throw new RuntimeException("Connection to LDAP server failed", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public class DisposableSubContext
    implements AutoCloseable {
        private final String distinguishedName;

        public DisposableSubContext(String distinguishedName) {
            this.distinguishedName = Objects.requireNonNull(distinguishedName, "distinguishedName is null");
        }

        public String getDistinguishedName() {
            return this.distinguishedName;
        }

        @Override
        public void close() throws Exception {
            DirContext context = TestingOpenLdapServer.this.createContext();
            context.destroySubcontext(this.distinguishedName);
            context.close();
        }
    }
}

