/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers.wait.strategy;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.wait.internal.ExternalPortListeningCheck;
import org.testcontainers.containers.wait.internal.InternalCommandPortListeningCheck;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public final class SelectedPortWaitStrategy
extends AbstractWaitStrategy {
    private final Set<Integer> exposedPorts;

    public SelectedPortWaitStrategy(int ... exposedPorts) {
        this((Set<Integer>)ImmutableSet.copyOf((Collection)Ints.asList((int[])exposedPorts)));
    }

    public SelectedPortWaitStrategy(Set<Integer> exposedPorts) {
        Objects.requireNonNull(exposedPorts, "exposedPorts is null");
        Preconditions.checkArgument((!exposedPorts.isEmpty() ? 1 : 0) != 0, (Object)"exposedPorts is empty");
        exposedPorts.forEach(exposedPort -> Preconditions.checkArgument((exposedPort != null && exposedPort > 0 ? 1 : 0) != 0, (String)"Invalid exposedPort: %s", (Object)exposedPort));
        this.exposedPorts = ImmutableSet.copyOf(exposedPorts);
    }

    protected void waitUntilReady() {
        InternalCommandPortListeningCheck internalCheck = new InternalCommandPortListeningCheck(this.waitStrategyTarget, this.exposedPorts);
        Set externalPorts = (Set)this.exposedPorts.stream().map(arg_0 -> ((WaitStrategyTarget)this.waitStrategyTarget).getMappedPort(arg_0)).collect(ImmutableSet.toImmutableSet());
        ExternalPortListeningCheck externalCheck = new ExternalPortListeningCheck((ContainerState)this.waitStrategyTarget, externalPorts);
        Failsafe.with((Policy)RetryPolicy.builder().withMaxDuration(this.startupTimeout).withMaxAttempts(Integer.MAX_VALUE).abortOn(e -> this.getExitCode().isPresent()).build(), (Policy[])new RetryPolicy[0]).run(() -> this.lambda$waitUntilReady$3((Callable)internalCheck, (Callable)externalCheck));
    }

    private Optional<Long> getExitCode() {
        if (this.waitStrategyTarget.getContainerId() == null) {
            return Optional.empty();
        }
        InspectContainerResponse currentContainerInfo = this.waitStrategyTarget.getCurrentContainerInfo();
        if (currentContainerInfo.getState().getStartedAt() == null) {
            return Optional.empty();
        }
        if (currentContainerInfo.getState().getRunning() != null && currentContainerInfo.getState().getRunning().booleanValue()) {
            return Optional.empty();
        }
        return Optional.ofNullable(currentContainerInfo.getState().getExitCodeLong());
    }

    private /* synthetic */ void lambda$waitUntilReady$3(Callable internalCheck, Callable externalCheck) throws Throwable {
        if (!((Boolean)this.getRateLimiter().getWhenReady(() -> (Boolean)internalCheck.call() != false && (Boolean)externalCheck.call() != false)).booleanValue()) {
            throw new ContainerLaunchException(String.format("Timed out waiting for container port to open (%s ports: %s should be listening)", this.waitStrategyTarget.getHost(), this.exposedPorts));
        }
    }
}

