/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.ClassPath;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.airlift.log.Logger;
import io.trino.testing.containers.BaseTestContainer;
import io.trino.testing.minio.MinioClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testcontainers.containers.Network;

public class Minio
extends BaseTestContainer {
    private static final Logger log = Logger.get(Minio.class);
    public static final String DEFAULT_IMAGE = "minio/minio:RELEASE.2022-10-05T14-58-27Z";
    public static final String DEFAULT_HOST_NAME = "minio";
    public static final int MINIO_API_PORT = 4566;
    public static final int MINIO_CONSOLE_PORT = 4567;
    public static final String MINIO_ACCESS_KEY = "accesskey";
    public static final String MINIO_SECRET_KEY = "secretkey";
    public static final String MINIO_REGION = "us-east-1";

    public static Builder builder() {
        return new Builder();
    }

    private Minio(String image, String hostName, Set<Integer> exposePorts, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int retryLimit) {
        super(image, hostName, exposePorts, filesToMount, envVars, network, retryLimit);
    }

    @Override
    protected void setupContainer() {
        super.setupContainer();
        this.withRunCommand((List<String>)ImmutableList.of((Object)"server", (Object)"--address", (Object)"0.0.0.0:4566", (Object)"--console-address", (Object)"0.0.0.0:4567", (Object)"/data"));
    }

    @Override
    public void start() {
        super.start();
        log.info("MinIO container started with address for api: http://%s and console: http://%s", new Object[]{this.getMinioApiEndpoint(), this.getMinioConsoleEndpoint()});
    }

    public HostAndPort getMinioApiEndpoint() {
        return this.getMappedHostAndPortForExposedPort(4566);
    }

    public String getMinioAddress() {
        return "http://" + this.getMinioApiEndpoint();
    }

    public HostAndPort getMinioConsoleEndpoint() {
        return this.getMappedHostAndPortForExposedPort(4567);
    }

    public void createBucket(String bucketName) {
        try (MinioClient minioClient = this.createMinioClient();){
            RetryPolicy retryPolicy = RetryPolicy.builder().withMaxDuration(Duration.of(2L, ChronoUnit.MINUTES)).withMaxAttempts(Integer.MAX_VALUE).withDelay(Duration.of(10L, ChronoUnit.SECONDS)).build();
            Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> minioClient.makeBucket(bucketName));
        }
    }

    public void copyResources(String resourcePath, String bucketName, String target) {
        try (MinioClient minioClient = this.createMinioClient();){
            for (ClassPath.ResourceInfo resourceInfo : ClassPath.from((ClassLoader)MinioClient.class.getClassLoader()).getResources()) {
                if (!resourceInfo.getResourceName().startsWith(resourcePath)) continue;
                String fileName = resourceInfo.getResourceName().replaceFirst("^" + Pattern.quote(resourcePath), Matcher.quoteReplacement(target));
                minioClient.putObject(bucketName, resourceInfo.asByteSource().read(), fileName);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeFile(byte[] contents, String bucketName, String path) {
        try (MinioClient minioClient = this.createMinioClient();){
            minioClient.putObject(bucketName, contents, path);
        }
    }

    public MinioClient createMinioClient() {
        return new MinioClient(this.getMinioAddress(), MINIO_ACCESS_KEY, MINIO_SECRET_KEY);
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, Minio> {
        private Builder() {
            this.image = Minio.DEFAULT_IMAGE;
            this.hostName = Minio.DEFAULT_HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)4566, (Object)4567);
            this.envVars = ImmutableMap.builder().put((Object)"MINIO_ACCESS_KEY", (Object)Minio.MINIO_ACCESS_KEY).put((Object)"MINIO_SECRET_KEY", (Object)Minio.MINIO_SECRET_KEY).buildOrThrow();
        }

        @Override
        public Minio build() {
            return new Minio(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

