/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.Version;
import com.google.common.base.Strings;
import com.sun.jna.Platform;
import java.util.Locale;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;

public class PlatformChecks
extends ImageNameSubstitutor {
    private static final boolean TESTCONTAINERS_SKIP_ARCH_CHECK = "true".equalsIgnoreCase(System.getenv("TESTCONTAINERS_SKIP_ARCHITECTURE_CHECK"));

    public DockerImageName apply(DockerImageName dockerImageName) {
        boolean isImageArmBased;
        boolean hasIncompatibleRuntime;
        if (TESTCONTAINERS_SKIP_ARCH_CHECK) {
            return dockerImageName;
        }
        DockerClient client = DockerClientFactory.lazyClient();
        if (!PlatformChecks.imageExists(client, dockerImageName)) {
            PlatformChecks.pullImage(client, dockerImageName);
        }
        String imageArch = PlatformChecks.getImageArch(client, dockerImageName);
        boolean isJavaOnArm = Platform.isARM();
        boolean bl = hasIncompatibleRuntime = isJavaOnArm != (isImageArmBased = imageArch.contains("arm"));
        if (hasIncompatibleRuntime) {
            String dockerArch = ((Version)client.versionCmd().exec()).getArch();
            System.err.println("\n!!! ERROR !!!\nDetected incompatible Docker image and host architectures. The performance of running docker images in such scenarios can vary or not work at all.\nHost: %s (%s).\nDocker architecture: %s.\nDocker image architecture: %s.\n\nSet environment variable TESTCONTAINERS_SKIP_ARCHITECTURE_CHECK=true to skip this check.\n!!! ERROR !!!\n".formatted(System.getProperty("os.name"), System.getProperty("os.arch"), dockerArch, imageArch));
            System.exit(99);
        }
        return dockerImageName;
    }

    protected String getDescription() {
        return "Image substitutor that checks whether the image platform matches host platform";
    }

    private static boolean imageExists(DockerClient client, DockerImageName imageName) {
        try {
            PlatformChecks.getImageArch(client, imageName);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static String getImageArch(DockerClient client, DockerImageName imageName) {
        return client.inspectImageCmd(imageName.asCanonicalNameString()).exec().getArch().toLowerCase(Locale.ENGLISH);
    }

    private static void pullImage(DockerClient client, final DockerImageName imageName) {
        try {
            (client.pullImageCmd(imageName.asCanonicalNameString()).exec((ResultCallback)new PullImageResultCallback(){

                public void onNext(PullResponseItem item) {
                    String progress = item.getProgress();
                    if (progress != null) {
                        System.err.println(Strings.padEnd((String)(imageName.asCanonicalNameString() + ":" + item.getId()), (int)50, (char)' ') + " " + progress);
                    }
                }
            })).awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

