/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.log.Logger;
import io.trino.testing.ResourcePresence;
import io.trino.testing.containers.TestContainers;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.startupcheck.IsRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public abstract class BaseTestContainer
implements AutoCloseable {
    private final Logger log;
    private final String hostName;
    private final Set<Integer> ports;
    private final Map<String, String> filesToMount;
    private final Map<String, String> envVars;
    private final Optional<Network> network;
    private final int startupRetryLimit;
    private GenericContainer<?> container;

    protected BaseTestContainer(String image, String hostName, Set<Integer> ports, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int startupRetryLimit) {
        Preconditions.checkArgument((startupRetryLimit > 0 ? 1 : 0) != 0, (Object)"startupRetryLimit needs to be greater or equal to 0");
        this.log = Logger.get(this.getClass());
        this.container = new GenericContainer(Objects.requireNonNull(image, "image is null"));
        this.ports = Objects.requireNonNull(ports, "ports is null");
        this.hostName = Objects.requireNonNull(hostName, "hostName is null");
        this.filesToMount = Objects.requireNonNull(filesToMount, "filesToMount is null");
        this.envVars = Objects.requireNonNull(envVars, "envVars is null");
        this.network = Objects.requireNonNull(network, "network is null");
        this.startupRetryLimit = startupRetryLimit;
        this.setupContainer();
    }

    protected void setupContainer() {
        for (int port : this.ports) {
            this.container.addExposedPort(Integer.valueOf(port));
        }
        this.filesToMount.forEach((dockerPath, filePath) -> this.container.withCopyFileToContainer(MountableFile.forHostPath((String)filePath), dockerPath));
        this.container.withEnv(this.envVars);
        this.container.withCreateContainerCmdModifier(c -> c.withHostName(this.hostName)).withStartupCheckStrategy((StartupCheckStrategy)new IsRunningStartupCheckStrategy()).waitingFor((WaitStrategy)Wait.forListeningPort()).withStartupTimeout(Duration.ofMinutes(5L));
        this.network.ifPresent(net -> this.container.withNetwork(net).withNetworkAliases(new String[]{this.hostName}));
    }

    protected void withRunCommand(List<String> runCommand) {
        this.container.withCommand(runCommand.toArray(new String[runCommand.size()]));
    }

    protected void withLogConsumer(Consumer<OutputFrame> logConsumer) {
        this.container.withLogConsumer(logConsumer);
    }

    protected void copyResourceToContainer(String resourcePath, String dockerPath) {
        this.container.withCopyFileToContainer(MountableFile.forHostPath((String)MountableFile.forClasspathResource((String)resourcePath).getResolvedPath()), dockerPath);
    }

    protected HostAndPort getMappedHostAndPortForExposedPort(int exposedPort) {
        return HostAndPort.fromParts((String)this.container.getHost(), (int)this.container.getMappedPort(exposedPort));
    }

    public void start() {
        Failsafe.with((Policy[])new RetryPolicy[]{new RetryPolicy().withMaxRetries(this.startupRetryLimit).onRetry(event -> this.log.warn("%s initialization failed (attempt %s), will retry. Exception: %s", new Object[]{this.getClass().getSimpleName(), event.getAttemptCount(), event.getLastFailure().getMessage()}))}).get(() -> TestContainers.startOrReuse(this.container));
    }

    public void stop() {
        this.container.stop();
    }

    public String executeInContainerFailOnError(String ... commandAndArgs) {
        Container.ExecResult execResult = this.executeInContainer(commandAndArgs);
        if (execResult.getExitCode() != 0) {
            String message = String.format("Command [%s] exited with %s", String.join((CharSequence)" ", commandAndArgs), execResult.getExitCode());
            this.log.error("%s", new Object[]{message});
            this.log.error("stderr: %s", new Object[]{execResult.getStderr()});
            this.log.error("stdout: %s", new Object[]{execResult.getStdout()});
            throw new RuntimeException(message);
        }
        return execResult.getStdout();
    }

    public Container.ExecResult executeInContainer(String ... commandAndArgs) {
        try {
            return this.container.execInContainer(commandAndArgs);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Exception while running command: " + String.join((CharSequence)" ", commandAndArgs), e);
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    @ResourcePresence
    public boolean isPresent() {
        return this.container.isRunning() || this.container.getContainerId() != null;
    }

    protected static abstract class Builder<SELF extends Builder<SELF, BUILD>, BUILD extends BaseTestContainer> {
        protected String image;
        protected String hostName;
        protected Set<Integer> exposePorts = ImmutableSet.of();
        protected Map<String, String> filesToMount = ImmutableMap.of();
        protected Map<String, String> envVars = ImmutableMap.of();
        protected Optional<Network> network = Optional.empty();
        protected int startupRetryLimit = 1;
        protected SELF self = this;

        public SELF withImage(String image) {
            this.image = image;
            return this.self;
        }

        public SELF withHostName(String hostName) {
            this.hostName = hostName;
            return this.self;
        }

        public SELF withExposePorts(Set<Integer> exposePorts) {
            this.exposePorts = exposePorts;
            return this.self;
        }

        public SELF withFilesToMount(Map<String, String> filesToMount) {
            this.filesToMount = filesToMount;
            return this.self;
        }

        public SELF withEnvVars(Map<String, String> envVars) {
            this.envVars = envVars;
            return this.self;
        }

        public SELF withNetwork(Network network) {
            this.network = Optional.of(network);
            return this.self;
        }

        public SELF withStartupRetryLimit(int startupRetryLimit) {
            this.startupRetryLimit = startupRetryLimit;
            return this.self;
        }

        public abstract BUILD build();
    }
}

