/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.TestcontainersConfiguration;

public final class TestContainers {
    private static final boolean TESTCONTAINERS_REUSE_ENABLE = Boolean.parseBoolean(System.getenv("TESTCONTAINERS_REUSE_ENABLE"));

    private TestContainers() {
    }

    public static Closeable startOrReuse(GenericContainer<?> container) {
        boolean reuse = TestcontainersConfiguration.getInstance().environmentSupportsReuse();
        Preconditions.checkState((reuse == TESTCONTAINERS_REUSE_ENABLE ? 1 : 0) != 0, (Object)"Unable to enable or disable container reuse");
        container.withReuse(TESTCONTAINERS_REUSE_ENABLE);
        container.start();
        if (reuse) {
            return () -> {};
        }
        return () -> container.stop();
    }

    public static String getPathFromClassPathResource(String resourcePath) {
        return MountableFile.forClasspathResource((String)resourcePath).getResolvedPath();
    }

    public static void exposeFixedPorts(GenericContainer<?> container) {
        Preconditions.checkState((System.getenv("CONTINUOUS_INTEGRATION") == null ? 1 : 0) != 0, (Object)"Exposing fixed ports should not be used in regular test code. This could break parallel test execution. This method is supposed to be invoked from local development helpers only e.g. QueryRunner.main(), hence it should never run on CI");
        container.withCreateContainerCmdModifier(cmd -> cmd.withHostConfig(Objects.requireNonNull(cmd.getHostConfig(), "hostConfig is null").withPortBindings((List)container.getExposedPorts().stream().map(exposedPort -> new PortBinding(Ports.Binding.bindPort((int)exposedPort), new ExposedPort(exposedPort.intValue()))).collect(ImmutableList.toImmutableList()))));
    }
}

