/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.inject.Inject;

public class RedshiftClient
extends BaseJdbcClient {
    @Inject
    public RedshiftClient(BaseJdbcConfig config, ConnectionFactory connectionFactory) {
        super(config, "\"", connectionFactory);
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(newTable.getTableName()));
        this.execute(session, sql);
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        return this.legacyToPrestoType(session, connection, typeHandle);
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        return this.legacyToWriteMapping(session, type);
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        String sql = String.format("COMMENT ON COLUMN %s.%s IS %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(column.getColumnName()), comment.isPresent() ? String.format("'%s'", comment.get()) : "NULL");
        this.execute(session, sql);
    }
}

