/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.inject.Inject;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderFactory;
import io.trino.decoder.protobuf.DynamicMessageProvider;
import io.trino.decoder.protobuf.ProtobufRowDecoder;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ProtobufRowDecoderFactory
implements RowDecoderFactory {
    public static final String DEFAULT_MESSAGE = "schema";
    private final DynamicMessageProvider.Factory dynamicMessageProviderFactory;
    private final TypeManager typeManager;

    @Inject
    public ProtobufRowDecoderFactory(DynamicMessageProvider.Factory dynamicMessageProviderFactory, TypeManager typeManager) {
        this.dynamicMessageProviderFactory = Objects.requireNonNull(dynamicMessageProviderFactory, "dynamicMessageProviderFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public RowDecoder create(Map<String, String> decoderParams, Set<DecoderColumnHandle> columns) {
        return new ProtobufRowDecoder(this.dynamicMessageProviderFactory.create(Optional.ofNullable(decoderParams.get("dataSchema"))), columns, this.typeManager);
    }
}

