/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import io.trino.decoder.DispatchingRowDecoderFactory;
import io.trino.decoder.RowDecoderFactory;
import io.trino.decoder.avro.AvroDecoderModule;
import io.trino.decoder.csv.CsvRowDecoderFactory;
import io.trino.decoder.dummy.DummyRowDecoderFactory;
import io.trino.decoder.json.JsonRowDecoderFactory;
import io.trino.decoder.raw.RawRowDecoderFactory;
import java.util.Objects;

public class DecoderModule
implements Module {
    private final Module extension;

    public DecoderModule() {
        this(new AvroDecoderModule());
    }

    public DecoderModule(Module extension) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
    }

    public void configure(Binder binder) {
        MapBinder decoderFactoriesByName = MapBinder.newMapBinder((Binder)binder, String.class, RowDecoderFactory.class);
        decoderFactoriesByName.addBinding((Object)"dummy").to(DummyRowDecoderFactory.class).in(Scopes.SINGLETON);
        decoderFactoriesByName.addBinding((Object)"csv").to(CsvRowDecoderFactory.class).in(Scopes.SINGLETON);
        decoderFactoriesByName.addBinding((Object)"json").to(JsonRowDecoderFactory.class).in(Scopes.SINGLETON);
        decoderFactoriesByName.addBinding((Object)"raw").to(RawRowDecoderFactory.class).in(Scopes.SINGLETON);
        binder.install(this.extension);
        binder.bind(DispatchingRowDecoderFactory.class).in(Scopes.SINGLETON);
    }
}

