/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.postgresql.PostgreSqlClient;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarcharType;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.postgresql.util.PGobject;

final class TypeUtils {
    private TypeUtils() {
    }

    static String getArrayElementPgTypeName(ConnectorSession session, PostgreSqlClient client, Type elementType) {
        if (DoubleType.DOUBLE.equals((Object)elementType)) {
            return "float8";
        }
        if (RealType.REAL.equals((Object)elementType)) {
            return "float4";
        }
        if (elementType instanceof VarcharType || elementType instanceof CharType) {
            return "varchar";
        }
        if (elementType instanceof TimestampWithTimeZoneType) {
            return "timestamptz";
        }
        if (elementType instanceof TimestampType) {
            return "timestamp";
        }
        if (elementType instanceof DecimalType) {
            return "decimal";
        }
        if (elementType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)elementType;
            return TypeUtils.getArrayElementPgTypeName(session, client, arrayType.getElementType());
        }
        return client.toWriteMapping(session, elementType).getDataType();
    }

    static Object[] getJdbcObjectArray(ConnectorSession session, Type elementType, Block block) throws SQLException {
        int positionCount = block.getPositionCount();
        Object[] valuesArray = new Object[positionCount];
        int subArrayLength = 1;
        for (int i = 0; i < positionCount; ++i) {
            Object objectValue;
            valuesArray[i] = objectValue = TypeUtils.trinoNativeToJdbcObject(session, elementType, io.trino.spi.type.TypeUtils.readNativeValue((Type)elementType, (Block)block, (int)i));
            if (objectValue == null || !objectValue.getClass().isArray()) continue;
            subArrayLength = Math.max(subArrayLength, Array.getLength(objectValue));
        }
        if (elementType instanceof ArrayType) {
            TypeUtils.handleArrayNulls(valuesArray, subArrayLength);
        }
        return valuesArray;
    }

    public static int arrayDepth(Object jdbcArray) {
        Preconditions.checkArgument((boolean)jdbcArray.getClass().isArray(), (Object)"jdbcArray is not an array");
        int depth = 0;
        while (jdbcArray != null && jdbcArray.getClass().isArray()) {
            ++depth;
            if (Array.getLength(jdbcArray) == 0) {
                return depth;
            }
            jdbcArray = Array.get(jdbcArray, 0);
        }
        return depth;
    }

    private static void handleArrayNulls(Object[] valuesArray, int length) {
        for (int i = 0; i < valuesArray.length; ++i) {
            if (valuesArray[i] != null) continue;
            valuesArray[i] = new Object[length];
        }
    }

    private static Object trinoNativeToJdbcObject(ConnectorSession session, Type trinoType, Object trinoNative) throws SQLException {
        TimestampType timestampType;
        if (trinoNative == null) {
            return null;
        }
        if (DoubleType.DOUBLE.equals((Object)trinoType) || BooleanType.BOOLEAN.equals((Object)trinoType) || BigintType.BIGINT.equals((Object)trinoType)) {
            return trinoNative;
        }
        if (trinoType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)trinoType;
            if (decimalType.isShort()) {
                BigInteger unscaledValue = BigInteger.valueOf((Long)trinoNative);
                return new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
            }
            BigInteger unscaledValue = ((Int128)trinoNative).toBigInteger();
            return new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
        }
        if (RealType.REAL.equals((Object)trinoType)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)trinoNative)));
        }
        if (TinyintType.TINYINT.equals((Object)trinoType)) {
            return SignedBytes.checkedCast((long)((Long)trinoNative));
        }
        if (SmallintType.SMALLINT.equals((Object)trinoType)) {
            return Shorts.checkedCast((long)((Long)trinoNative));
        }
        if (IntegerType.INTEGER.equals((Object)trinoType)) {
            return Math.toIntExact((Long)trinoNative);
        }
        if (DateType.DATE.equals((Object)trinoType)) {
            long millis = TimeUnit.DAYS.toMillis((Long)trinoNative);
            return new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millis));
        }
        if (trinoType instanceof TimestampType && (timestampType = (TimestampType)trinoType).isShort()) {
            return TypeUtils.toPgTimestamp(StandardColumnMappings.fromTrinoTimestamp((long)((Long)trinoNative)));
        }
        if (trinoType instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)trinoType;
            int precision = timestampWithTimeZoneType.getPrecision();
            if (precision <= 3) {
                long millisUtc = DateTimeEncoding.unpackMillisUtc((long)((Long)trinoNative));
                return new Timestamp(millisUtc);
            }
            LongTimestampWithTimeZone value = (LongTimestampWithTimeZone)trinoNative;
            long epochSeconds = Math.floorDiv(value.getEpochMillis(), 1000);
            long nanosOfSecond = Math.floorMod(value.getEpochMillis(), 1000) * 1000000 + value.getPicosOfMilli() / 1000;
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds, nanosOfSecond), TimeZoneKey.UTC_KEY.getZoneId());
        }
        if (trinoType instanceof VarcharType || trinoType instanceof CharType) {
            return ((Slice)trinoNative).toStringUtf8();
        }
        if (trinoType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)trinoType;
            return TypeUtils.getJdbcObjectArray(session, arrayType.getElementType(), (Block)trinoNative);
        }
        if (UuidType.UUID.equals((Object)trinoType)) {
            return UuidType.trinoUuidToJavaUuid((Slice)((Slice)trinoNative));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(trinoType));
    }

    static PGobject toPgTimestamp(LocalDateTime localDateTime) throws SQLException {
        PGobject pgObject = new PGobject();
        pgObject.setType("timestamp");
        pgObject.setValue(localDateTime.toString());
        return pgObject;
    }
}

