/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.projection.ProjectFunctionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.VarcharType;
import java.sql.JDBCType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class RewriteStringReverseFunction
implements ProjectFunctionRule<JdbcExpression, ParameterizedExpression> {
    private static final Capture<Variable> ARGUMENT = Capture.newCapture();
    private static final Pattern<Call> PATTERN = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)new FunctionName("reverse"))).with(ConnectorExpressionPatterns.type().matching(type -> type instanceof VarcharType)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)1)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.variable().capturedAs(ARGUMENT).with(ConnectorExpressionPatterns.type().matching(type -> type instanceof VarcharType))));

    public Pattern<? extends ConnectorExpression> getPattern() {
        return PATTERN;
    }

    public Optional<JdbcExpression> rewrite(ConnectorTableHandle handle, ConnectorExpression projectionExpression, Captures captures, ProjectFunctionRule.RewriteContext<ParameterizedExpression> context) {
        Variable argument = (Variable)captures.get(ARGUMENT);
        JdbcTypeHandle typeHandle = ((JdbcColumnHandle)context.getAssignment(argument.getName())).getJdbcTypeHandle();
        if (JDBCType.valueOf(typeHandle.jdbcType()) == JDBCType.VARCHAR && typeHandle.jdbcTypeName().map("varchar"::equals).orElse(false).booleanValue()) {
            Optional translatedArgument = context.rewriteExpression((ConnectorExpression)argument);
            if (translatedArgument.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new JdbcExpression("REVERSE(%s)".formatted(((ParameterizedExpression)translatedArgument.get()).expression()), (List)ImmutableList.copyOf((Collection)((ParameterizedExpression)translatedArgument.get()).parameters()), typeHandle));
        }
        return Optional.empty();
    }
}

