/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.logging;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FormatInterpolator<Context> {
    private final String format;
    private final List<InterpolatedValue<Context>> values;

    public FormatInterpolator(String format, List<InterpolatedValue<Context>> values) {
        this.format = (String)MoreObjects.firstNonNull((Object)format, (Object)"");
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
    }

    @SafeVarargs
    public FormatInterpolator(String format, InterpolatedValue<Context> ... values) {
        this(format, Arrays.stream(values).toList());
    }

    public String interpolate(Context context) {
        String result = this.format;
        for (InterpolatedValue<Context> value : this.values) {
            if (!result.contains(value.getCode())) continue;
            result = result.replaceAll(value.getMatchCase(), value.value(context));
        }
        return result;
    }

    public static boolean hasValidPlaceholders(String format, InterpolatedValue<?> ... values) {
        return FormatInterpolator.hasValidPlaceholders(format, Arrays.stream(values).toList());
    }

    public static boolean hasValidPlaceholders(String format, List<InterpolatedValue<?>> values) {
        List<String> matches = values.stream().map(InterpolatedValue::getMatchCase).toList();
        Pattern pattern = Pattern.compile("[\\w ,_\\-=]|" + String.join((CharSequence)"|", matches));
        Matcher matcher = pattern.matcher(format);
        return matcher.results().map(MatchResult::group).collect(Collectors.joining()).equals(format);
    }

    public static interface InterpolatedValue<Context> {
        public String name();

        default public String getCode() {
            return "$" + this.name();
        }

        default public String getMatchCase() {
            return "\\$" + this.name();
        }

        public String value(Context var1);
    }
}

