/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.aggregation;

import io.trino.matching.Captures;
import io.trino.matching.CustomPattern;
import io.trino.matching.Match;
import io.trino.matching.Pattern;
import io.trino.matching.Property;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class AggregateFunctionPatterns {
    private AggregateFunctionPatterns() {
    }

    public static Pattern<AggregateFunction> basicAggregation() {
        return Pattern.typeOf(AggregateFunction.class).with(AggregateFunctionPatterns.hasSortOrder().equalTo((Object)false)).with(AggregateFunctionPatterns.distinct().equalTo((Object)false)).with(AggregateFunctionPatterns.hasFilter().equalTo((Object)false));
    }

    public static Property<AggregateFunction, ?, String> functionName() {
        return Property.property((String)"functionName", AggregateFunction::getFunctionName);
    }

    public static Property<AggregateFunction, ?, Type> outputType() {
        return Property.property((String)"outputType", AggregateFunction::getOutputType);
    }

    public static Property<AggregateFunction, ?, List<ConnectorExpression>> arguments() {
        return Property.property((String)"arguments", AggregateFunction::getArguments);
    }

    public static Property<AggregateFunction, ?, ConnectorExpression> singleArgument() {
        return Property.optionalProperty((String)"arguments", aggregateFunction -> {
            List arguments = aggregateFunction.getArguments();
            if (arguments.size() != 1) {
                return Optional.empty();
            }
            return Optional.of((ConnectorExpression)arguments.get(0));
        });
    }

    public static Property<AggregateFunction, ?, Boolean> hasSortOrder() {
        return Property.property((String)"hasSortOrder", aggregateFunction -> !aggregateFunction.getSortItems().isEmpty());
    }

    public static Property<AggregateFunction, ?, Boolean> distinct() {
        return Property.property((String)"distinct", AggregateFunction::isDistinct);
    }

    public static Property<AggregateFunction, ?, Boolean> hasFilter() {
        return Property.property((String)"hasFilter", aggregateFunction -> aggregateFunction.getFilter().isPresent());
    }

    public static Pattern<List<Variable>> variables() {
        return new CustomPattern<List<Variable>>(Optional.empty()){

            public <C> Stream<Match> accept(Object object, Captures captures, C context) {
                if (!(object instanceof List)) {
                    return Stream.of(new Match[0]);
                }
                List arguments = (List)object;
                if (!arguments.stream().allMatch(Variable.class::isInstance)) {
                    return Stream.of(new Match[0]);
                }
                return Stream.of(Match.of((Captures)captures));
            }

            public String print() {
                return "variables()";
            }
        };
    }
}

