/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.ldap;

import java.util.Arrays;
import java.util.Objects;

public class LdapQuery {
    private final String searchBase;
    private final String searchFilter;
    private final String[] attributes;

    private LdapQuery(String searchBase, String searchFilter, String[] attributes) {
        this.searchBase = Objects.requireNonNull(searchBase, "searchBase is null");
        this.searchFilter = Objects.requireNonNull(searchFilter, "searchFilter is null");
        Objects.requireNonNull(attributes, "attributes is null");
        this.attributes = Arrays.copyOf(attributes, attributes.length);
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public static class LdapQueryBuilder {
        private String searchBase;
        private String searchFilter;
        private String[] attributes = new String[0];

        public LdapQueryBuilder withSearchBase(String searchBase) {
            this.searchBase = Objects.requireNonNull(searchBase, "searchBase is null");
            return this;
        }

        public LdapQueryBuilder withSearchFilter(String searchFilter) {
            this.searchFilter = Objects.requireNonNull(searchFilter, "searchFilter is null");
            return this;
        }

        public LdapQueryBuilder withAttributes(String ... attributes) {
            this.attributes = Objects.requireNonNull(attributes, "attributes is null");
            return this;
        }

        public LdapQuery build() {
            return new LdapQuery(this.searchBase, this.searchFilter, this.attributes);
        }
    }
}

