/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import jakarta.annotation.PreDestroy;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class ClosingBinder {
    private final Multibinder<ExecutorService> executors;
    private final Multibinder<Closeable> closeables;

    public static ClosingBinder closingBinder(Binder binder) {
        return new ClosingBinder(binder);
    }

    private ClosingBinder(Binder binder) {
        this.executors = Multibinder.newSetBinder((Binder)binder, ExecutorService.class, ForCleanup.class);
        this.closeables = Multibinder.newSetBinder((Binder)binder, Closeable.class, ForCleanup.class);
        binder.bind(Cleanup.class).asEagerSingleton();
    }

    public void registerExecutor(Class<? extends ExecutorService> type) {
        this.registerExecutor((Key<? extends ExecutorService>)Key.get(type));
    }

    public void registerExecutor(Key<? extends ExecutorService> key) {
        this.executors.addBinding().to(Objects.requireNonNull(key, "key is null"));
    }

    public void registerCloseable(Class<? extends Closeable> type) {
        this.registerCloseable((Key<? extends Closeable>)Key.get(type));
    }

    public void registerCloseable(Key<? extends Closeable> key) {
        this.closeables.addBinding().to(key);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    private static @interface ForCleanup {
    }

    private record Cleanup(@ForCleanup Set<ExecutorService> executors, @ForCleanup Set<Closeable> closeables) {
        @Inject
        private Cleanup {
            executors = ImmutableSet.copyOf(executors);
            closeables = ImmutableSet.copyOf(closeables);
        }

        @PreDestroy
        public void shutdown() throws IOException {
            try (Closer closer = Closer.create();){
                this.executors.forEach(executor -> closer.register(executor::shutdownNow));
                this.closeables.forEach(arg_0 -> ((Closer)closer).register(arg_0));
            }
        }
    }
}

