/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.security.CatalogAccessControlRule;
import io.trino.plugin.base.security.CatalogFunctionAccessControlRule;
import io.trino.plugin.base.security.CatalogSchemaAccessControlRule;
import io.trino.plugin.base.security.CatalogSessionPropertyAccessControlRule;
import io.trino.plugin.base.security.CatalogTableAccessControlRule;
import io.trino.plugin.base.security.ImpersonationRule;
import io.trino.plugin.base.security.PrincipalUserMatchRule;
import io.trino.plugin.base.security.QueryAccessRule;
import io.trino.plugin.base.security.SessionPropertyAccessControlRule;
import io.trino.plugin.base.security.SystemInformationRule;
import java.util.List;
import java.util.Optional;

public class FileBasedSystemAccessControlRules {
    private final Optional<List<CatalogAccessControlRule>> catalogRules;
    private final Optional<List<QueryAccessRule>> queryAccessRules;
    private final Optional<List<ImpersonationRule>> impersonationRules;
    private final Optional<List<PrincipalUserMatchRule>> principalUserMatchRules;
    private final Optional<List<SystemInformationRule>> systemInformationRules;
    private final Optional<List<CatalogSchemaAccessControlRule>> schemaRules;
    private final Optional<List<CatalogTableAccessControlRule>> tableRules;
    private final Optional<List<SessionPropertyAccessControlRule>> sessionPropertyRules;
    private final Optional<List<CatalogSessionPropertyAccessControlRule>> catalogSessionPropertyRules;
    private final Optional<List<CatalogFunctionAccessControlRule>> functionRules;

    @JsonCreator
    public FileBasedSystemAccessControlRules(@JsonProperty(value="catalogs") Optional<List<CatalogAccessControlRule>> catalogRules, @JsonProperty(value="queries") Optional<List<QueryAccessRule>> queryAccessRules, @JsonProperty(value="impersonation") Optional<List<ImpersonationRule>> impersonationRules, @JsonProperty(value="principals") Optional<List<PrincipalUserMatchRule>> principalUserMatchRules, @JsonProperty(value="system_information") Optional<List<SystemInformationRule>> systemInformationRules, @JsonProperty(value="schemas") Optional<List<CatalogSchemaAccessControlRule>> schemaAccessControlRules, @JsonProperty(value="tables") Optional<List<CatalogTableAccessControlRule>> tableAccessControlRules, @JsonProperty(value="system_session_properties") Optional<List<SessionPropertyAccessControlRule>> sessionPropertyRules, @JsonProperty(value="catalog_session_properties") Optional<List<CatalogSessionPropertyAccessControlRule>> catalogSessionPropertyRules, @JsonProperty(value="functions") Optional<List<CatalogFunctionAccessControlRule>> functionRules) {
        this.catalogRules = catalogRules.map(ImmutableList::copyOf);
        this.queryAccessRules = queryAccessRules.map(ImmutableList::copyOf);
        this.principalUserMatchRules = principalUserMatchRules.map(ImmutableList::copyOf);
        this.impersonationRules = impersonationRules.map(ImmutableList::copyOf);
        this.systemInformationRules = systemInformationRules.map(ImmutableList::copyOf);
        this.schemaRules = schemaAccessControlRules.map(ImmutableList::copyOf);
        this.tableRules = tableAccessControlRules.map(ImmutableList::copyOf);
        this.sessionPropertyRules = sessionPropertyRules.map(ImmutableList::copyOf);
        this.catalogSessionPropertyRules = catalogSessionPropertyRules.map(ImmutableList::copyOf);
        this.functionRules = functionRules.map(ImmutableList::copyOf);
    }

    public Optional<List<CatalogAccessControlRule>> getCatalogRules() {
        return this.catalogRules;
    }

    public Optional<List<QueryAccessRule>> getQueryAccessRules() {
        return this.queryAccessRules;
    }

    public Optional<List<ImpersonationRule>> getImpersonationRules() {
        return this.impersonationRules;
    }

    public Optional<List<PrincipalUserMatchRule>> getPrincipalUserMatchRules() {
        return this.principalUserMatchRules;
    }

    public Optional<List<SystemInformationRule>> getSystemInformationRules() {
        return this.systemInformationRules;
    }

    public Optional<List<CatalogSchemaAccessControlRule>> getSchemaRules() {
        return this.schemaRules;
    }

    public Optional<List<CatalogTableAccessControlRule>> getTableRules() {
        return this.tableRules;
    }

    public Optional<List<SessionPropertyAccessControlRule>> getSessionPropertyRules() {
        return this.sessionPropertyRules;
    }

    public Optional<List<CatalogSessionPropertyAccessControlRule>> getCatalogSessionPropertyRules() {
        return this.catalogSessionPropertyRules;
    }

    public Optional<List<CatalogFunctionAccessControlRule>> getFunctionRules() {
        return this.functionRules;
    }
}

