/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class CatalogAccessControlRule {
    public static final CatalogAccessControlRule ALLOW_ALL = new CatalogAccessControlRule(AccessMode.ALL, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private final AccessMode accessMode;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> roleRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> catalogRegex;

    @JsonCreator
    public CatalogAccessControlRule(@JsonProperty(value="allow") AccessMode accessMode, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="role") Optional<Pattern> roleRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="catalog") Optional<Pattern> catalogRegex) {
        this.accessMode = Objects.requireNonNull(accessMode, "accessMode is null");
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.roleRegex = Objects.requireNonNull(roleRegex, "roleRegex is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "groupRegex is null");
        this.catalogRegex = Objects.requireNonNull(catalogRegex, "catalogRegex is null");
    }

    public Optional<AccessMode> match(String user, Set<String> roles, Set<String> groups, String catalog) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.roleRegex.map(regex -> roles.stream().anyMatch(role -> regex.matcher((CharSequence)role).matches())).orElse(true).booleanValue() && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true).booleanValue() && this.catalogRegex.map(regex -> regex.matcher(catalog).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.accessMode);
        }
        return Optional.empty();
    }

    public static enum AccessMode {
        ALL("all"),
        READ_ONLY("read-only"),
        NONE("none");

        private static final Map<String, AccessMode> modeByName;
        private final String stringValue;

        private AccessMode(String stringValue) {
            this.stringValue = Objects.requireNonNull(stringValue, "stringValue is null");
        }

        @JsonValue
        public String toString() {
            return this.stringValue;
        }

        @JsonCreator
        public static AccessMode fromJson(Object value) {
            AccessMode accessMode;
            if (Boolean.TRUE.equals(value)) {
                return ALL;
            }
            if (Boolean.FALSE.equals(value)) {
                return NONE;
            }
            if (value instanceof String && (accessMode = modeByName.get(((String)value).toLowerCase(Locale.US))) != null) {
                return accessMode;
            }
            throw new IllegalArgumentException("Unknown " + AccessMode.class.getSimpleName() + ": " + String.valueOf(value));
        }

        boolean implies(AccessMode other) {
            if (this == ALL && other == READ_ONLY) {
                return true;
            }
            return this == other;
        }

        static {
            modeByName = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])AccessMode.values()), AccessMode::toString);
        }
    }
}

