/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.ldap;

import com.google.common.base.Strings;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Optional;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@DefunctConfig(value={"ldap.ssl-trust-certificate"})
public class LdapClientConfig {
    private String ldapUrl;
    private boolean allowInsecure;
    private File keystorePath;
    private String keystorePassword;
    private File trustStorePath;
    private String truststorePassword;
    private boolean ignoreReferrals;
    private Optional<Duration> ldapConnectionTimeout = Optional.empty();
    private Optional<Duration> ldapReadTimeout = Optional.empty();

    @NotNull
    @Pattern(regexp="^ldaps?://.*", message="Invalid LDAP server URL. Expected ldap:// or ldaps://")
    public @NotNull @Pattern(regexp="^ldaps?://.*", message="Invalid LDAP server URL. Expected ldap:// or ldaps://") String getLdapUrl() {
        return this.ldapUrl;
    }

    @Config(value="ldap.url")
    @ConfigDescription(value="URL of the LDAP server")
    public LdapClientConfig setLdapUrl(String url) {
        this.ldapUrl = url;
        return this;
    }

    public boolean isAllowInsecure() {
        return this.allowInsecure;
    }

    @Config(value="ldap.allow-insecure")
    @ConfigDescription(value="Allow insecure connection to the LDAP server")
    public LdapClientConfig setAllowInsecure(boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    @AssertTrue(message="Connecting to the LDAP server without SSL enabled requires `ldap.allow-insecure=true`")
    public @AssertTrue(message="Connecting to the LDAP server without SSL enabled requires `ldap.allow-insecure=true`") boolean isUrlConfigurationValid() {
        return Strings.nullToEmpty((String)this.ldapUrl).startsWith("ldaps://") || this.allowInsecure;
    }

    public Optional<@FileExists File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="ldap.ssl.keystore.path")
    @ConfigDescription(value="Path to the PEM or JKS key store")
    public LdapClientConfig setKeystorePath(File path) {
        this.keystorePath = path;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="ldap.ssl.keystore.password")
    @ConfigSecuritySensitive
    @ConfigDescription(value="Password for the key store")
    public LdapClientConfig setKeystorePassword(String password) {
        this.keystorePassword = password;
        return this;
    }

    public Optional<@FileExists File> getTrustStorePath() {
        return Optional.ofNullable(this.trustStorePath);
    }

    @Config(value="ldap.ssl.truststore.path")
    @ConfigDescription(value="Path to the PEM or JKS trust store")
    public LdapClientConfig setTrustStorePath(File path) {
        this.trustStorePath = path;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="ldap.ssl.truststore.password")
    @ConfigSecuritySensitive
    @ConfigDescription(value="Password for the trust store")
    public LdapClientConfig setTruststorePassword(String password) {
        this.truststorePassword = password;
        return this;
    }

    public boolean isIgnoreReferrals() {
        return this.ignoreReferrals;
    }

    @Config(value="ldap.ignore-referrals")
    @ConfigDescription(value="Referrals allow finding entries across multiple LDAP servers. Ignore them to only search within 1 LDAP server")
    public LdapClientConfig setIgnoreReferrals(boolean ignoreReferrals) {
        this.ignoreReferrals = ignoreReferrals;
        return this;
    }

    public Optional<Duration> getLdapConnectionTimeout() {
        return this.ldapConnectionTimeout;
    }

    @Config(value="ldap.timeout.connect")
    @ConfigDescription(value="Timeout for establishing a connection")
    public LdapClientConfig setLdapConnectionTimeout(Duration ldapConnectionTimeout) {
        this.ldapConnectionTimeout = Optional.ofNullable(ldapConnectionTimeout);
        return this;
    }

    public Optional<Duration> getLdapReadTimeout() {
        return this.ldapReadTimeout;
    }

    @Config(value="ldap.timeout.read")
    @ConfigDescription(value="Timeout for reading data from LDAP")
    public LdapClientConfig setLdapReadTimeout(Duration ldapReadTimeout) {
        this.ldapReadTimeout = Optional.ofNullable(ldapReadTimeout);
        return this;
    }
}

