/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleHash;
import it.unimi.dsi.fastutil.doubles.DoubleOpenCustomHashSet;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.longs.LongOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.Set;

public final class FastutilSetHelper {
    private FastutilSetHelper() {
    }

    public static Set<?> toFastutilHashSet(Set<?> set, Type type, MethodHandle hashCodeHandle, MethodHandle equalsHandle) {
        Objects.requireNonNull(set, "set is null");
        Objects.requireNonNull(type, "type is null");
        Class javaElementType = type.getJavaType();
        if (javaElementType == Long.TYPE) {
            return new LongOpenCustomHashSet(set, 0.25f, (LongHash.Strategy)new LongStrategy(hashCodeHandle, equalsHandle));
        }
        if (javaElementType == Double.TYPE) {
            return new DoubleOpenCustomHashSet(set, 0.25f, (DoubleHash.Strategy)new DoubleStrategy(hashCodeHandle, equalsHandle));
        }
        if (javaElementType == Boolean.TYPE) {
            return new BooleanOpenHashSet(set, 0.25f);
        }
        if (!type.getJavaType().isPrimitive()) {
            return new ObjectOpenCustomHashSet(set, 0.25f, (Hash.Strategy)new ObjectStrategy(hashCodeHandle, equalsHandle));
        }
        throw new UnsupportedOperationException("Unsupported native type in set: " + type.getJavaType() + " with type " + type.getTypeSignature());
    }

    public static boolean in(boolean booleanValue, BooleanOpenHashSet set) {
        return set.contains(booleanValue);
    }

    public static boolean in(double doubleValue, DoubleOpenCustomHashSet set) {
        return set.contains(doubleValue);
    }

    public static boolean in(long longValue, LongOpenCustomHashSet set) {
        return set.contains(longValue);
    }

    public static boolean in(Object objectValue, ObjectOpenCustomHashSet<?> set) {
        return set.contains(objectValue);
    }

    private static final class ObjectStrategy
    implements Hash.Strategy<Object> {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        public ObjectStrategy(MethodHandle hashCodeHandle, MethodHandle equalsHandle) {
            this.hashCodeHandle = Objects.requireNonNull(hashCodeHandle, "hashCodeHandle is null").asType(MethodType.methodType(Long.TYPE, Object.class));
            this.equalsHandle = Objects.requireNonNull(equalsHandle, "equalsHandle is null").asType(MethodType.methodType(Boolean.class, Object.class, Object.class));
        }

        public int hashCode(Object value) {
            if (value == null) {
                return 0;
            }
            try {
                return Long.hashCode(this.hashCodeHandle.invokeExact(value));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(Object a, Object b) {
            if (b == null || a == null) {
                return a == null && b == null;
            }
            try {
                Boolean result = this.equalsHandle.invokeExact(a, b);
                Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
                return Boolean.TRUE.equals(result);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    private static final class DoubleStrategy
    implements DoubleHash.Strategy {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        public DoubleStrategy(MethodHandle hashCodeHandle, MethodHandle equalsHandle) {
            this.hashCodeHandle = Objects.requireNonNull(hashCodeHandle, "hashCodeHandle is null");
            this.equalsHandle = Objects.requireNonNull(equalsHandle, "equalsHandle is null");
        }

        public int hashCode(double value) {
            try {
                return Long.hashCode(this.hashCodeHandle.invokeExact(value));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(double a, double b) {
            try {
                Boolean result = this.equalsHandle.invokeExact(a, b);
                Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
                return Boolean.TRUE.equals(result);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    private static final class LongStrategy
    implements LongHash.Strategy {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        public LongStrategy(MethodHandle hashCodeHandle, MethodHandle equalsHandle) {
            this.hashCodeHandle = Objects.requireNonNull(hashCodeHandle, "hashCodeHandle is null");
            this.equalsHandle = Objects.requireNonNull(equalsHandle, "equalsHandle is null");
        }

        public int hashCode(long value) {
            try {
                return Long.hashCode(this.hashCodeHandle.invokeExact(value));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(long a, long b) {
            try {
                Boolean result = this.equalsHandle.invokeExact(a, b);
                Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
                return Boolean.TRUE.equals(result);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }
}

