/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.base.security.AnyCatalogPermissionsRule;
import io.trino.plugin.base.security.AnyCatalogSchemaPermissionsRule;
import io.trino.plugin.base.security.ColumnConstraint;
import io.trino.plugin.base.security.ExpressionEnvironment;
import io.trino.plugin.base.security.TableAccessControlRule;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.security.ViewExpression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class CatalogTableAccessControlRule {
    public static final CatalogTableAccessControlRule ALLOW_ALL = new CatalogTableAccessControlRule(TableAccessControlRule.ALLOW_ALL, Optional.empty());
    private final TableAccessControlRule tableAccessControlRule;
    private final Optional<Pattern> catalogRegex;

    @JsonCreator
    public CatalogTableAccessControlRule(@JsonProperty(value="privileges") Set<TableAccessControlRule.TablePrivilege> privileges, @JsonProperty(value="columns") Optional<List<ColumnConstraint>> columns, @JsonProperty(value="filter") Optional<String> filter, @JsonProperty(value="filter_environment") Optional<ExpressionEnvironment> filterEnvironment, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="table") Optional<Pattern> tableRegex, @JsonProperty(value="catalog") Optional<Pattern> catalogRegex) {
        this.tableAccessControlRule = new TableAccessControlRule(privileges, columns, filter, filterEnvironment, userRegex, groupRegex, schemaRegex, tableRegex);
        this.catalogRegex = Objects.requireNonNull(catalogRegex, "catalogRegex is null");
    }

    public CatalogTableAccessControlRule(TableAccessControlRule tableAccessControlRule, Optional<Pattern> catalogRegex) {
        this.tableAccessControlRule = tableAccessControlRule;
        this.catalogRegex = catalogRegex;
    }

    public boolean matches(String user, Set<String> groups, CatalogSchemaTableName table) {
        if (!this.catalogRegex.map(regex -> regex.matcher(table.getCatalogName()).matches()).orElse(true).booleanValue()) {
            return false;
        }
        return this.tableAccessControlRule.matches(user, groups, table.getSchemaTableName());
    }

    public Set<TableAccessControlRule.TablePrivilege> getPrivileges() {
        return this.tableAccessControlRule.getPrivileges();
    }

    public Set<String> getRestrictedColumns() {
        return this.tableAccessControlRule.getRestrictedColumns();
    }

    public boolean canSelectColumns(Set<String> columnNames) {
        return this.tableAccessControlRule.canSelectColumns(columnNames);
    }

    public Optional<ViewExpression> getColumnMask(String user, String catalog, String schema, String column) {
        return this.tableAccessControlRule.getColumnMask(user, catalog, schema, column);
    }

    public Optional<ViewExpression> getFilter(String user, String catalog, String schema) {
        return this.tableAccessControlRule.getFilter(user, catalog, schema);
    }

    Optional<AnyCatalogPermissionsRule> toAnyCatalogPermissionsRule() {
        if (this.tableAccessControlRule.getPrivileges().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogPermissionsRule(this.tableAccessControlRule.getUserRegex(), this.tableAccessControlRule.getGroupRegex(), this.catalogRegex));
    }

    Optional<AnyCatalogSchemaPermissionsRule> toAnyCatalogSchemaPermissionsRule() {
        if (this.tableAccessControlRule.getPrivileges().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogSchemaPermissionsRule(this.tableAccessControlRule.getUserRegex(), this.tableAccessControlRule.getGroupRegex(), this.catalogRegex, this.tableAccessControlRule.getSchemaRegex()));
    }
}

