/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.plugin.base.security.AnySchemaPermissionsRule;
import io.trino.plugin.base.security.ColumnConstraint;
import io.trino.plugin.base.security.ExpressionEnvironment;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.ViewExpression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class TableAccessControlRule {
    public static final TableAccessControlRule ALLOW_ALL = new TableAccessControlRule((Set<TablePrivilege>)ImmutableSet.copyOf((Object[])TablePrivilege.values()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private final Set<TablePrivilege> privileges;
    private final Map<String, ColumnConstraint> columnConstraints;
    private final Set<String> restrictedColumns;
    private final Optional<String> filter;
    private final Optional<ExpressionEnvironment> filterEnvironment;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> schemaRegex;
    private final Optional<Pattern> tableRegex;

    @JsonCreator
    public TableAccessControlRule(@JsonProperty(value="privileges") Set<TablePrivilege> privileges, @JsonProperty(value="columns") Optional<List<ColumnConstraint>> columns, @JsonProperty(value="filter") Optional<String> filter, @JsonProperty(value="filter_environment") Optional<ExpressionEnvironment> filterEnvironment, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="table") Optional<Pattern> tableRegex) {
        this.privileges = ImmutableSet.copyOf((Collection)Objects.requireNonNull(privileges, "privileges is null"));
        this.columnConstraints = Maps.uniqueIndex((Iterable)Objects.requireNonNull(columns, "columns is null").orElse((List<ColumnConstraint>)ImmutableList.of()), ColumnConstraint::getName);
        this.restrictedColumns = (Set)this.columnConstraints.values().stream().filter(constraint -> !constraint.isAllowed()).map(ColumnConstraint::getName).collect(ImmutableSet.toImmutableSet());
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.filterEnvironment = Objects.requireNonNull(filterEnvironment, "filterEnvironment is null");
        this.userRegex = Objects.requireNonNull(userRegex, "user is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "group is null");
        this.schemaRegex = Objects.requireNonNull(schemaRegex, "sourceRegex is null");
        this.tableRegex = Objects.requireNonNull(tableRegex, "tableRegex is null");
    }

    public boolean matches(String user, Set<String> groups, SchemaTableName table) {
        return this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true) != false && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true) != false && this.schemaRegex.map(regex -> regex.matcher(table.getSchemaName()).matches()).orElse(true) != false && this.tableRegex.map(regex -> regex.matcher(table.getTableName()).matches()).orElse(true) != false;
    }

    public Set<String> getRestrictedColumns() {
        return this.restrictedColumns;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canSelectColumns(Set<String> columnNames) {
        if (!this.privileges.contains((Object)TablePrivilege.SELECT)) {
            if (!this.privileges.contains((Object)TablePrivilege.GRANT_SELECT)) return false;
        }
        if (!this.restrictedColumns.stream().noneMatch(columnNames::contains)) return false;
        return true;
    }

    public Optional<ViewExpression> getColumnMask(String user, String catalog, String schema, String column) {
        return Optional.ofNullable(this.columnConstraints.get(column)).flatMap(constraint -> constraint.getMask().map(mask -> new ViewExpression(constraint.getMaskEnvironment().flatMap(ExpressionEnvironment::getUser).orElse(user), Optional.of(catalog), Optional.of(schema), mask)));
    }

    public Optional<ViewExpression> getFilter(String user, String catalog, String schema) {
        return this.filter.map(filter -> new ViewExpression(this.filterEnvironment.flatMap(ExpressionEnvironment::getUser).orElse(user), Optional.of(catalog), Optional.of(schema), filter));
    }

    Optional<AnySchemaPermissionsRule> toAnySchemaPermissionsRule() {
        if (this.privileges.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnySchemaPermissionsRule(this.userRegex, this.groupRegex, this.schemaRegex));
    }

    Set<TablePrivilege> getPrivileges() {
        return this.privileges;
    }

    Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    Optional<Pattern> getGroupRegex() {
        return this.groupRegex;
    }

    Optional<Pattern> getSchemaRegex() {
        return this.schemaRegex;
    }

    public static enum TablePrivilege {
        SELECT,
        INSERT,
        DELETE,
        OWNERSHIP,
        GRANT_SELECT;

    }
}

