/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.file;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class FileGroupConfig {
    private File groupFile;
    private Duration refreshPeriod = new Duration(5.0, TimeUnit.SECONDS);

    @NotNull
    @FileExists
    public File getGroupFile() {
        return this.groupFile;
    }

    @Config(value="file.group-file")
    @ConfigDescription(value="Location of the file that provides user group membership")
    public FileGroupConfig setGroupFile(File groupFile) {
        this.groupFile = groupFile;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public @NotNull @MinDuration(value="1ms") Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }

    @Config(value="file.refresh-period")
    @ConfigDescription(value="How often to reload the group file")
    public FileGroupConfig setRefreshPeriod(Duration refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
        return this;
    }
}

