/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NumericParser;
import java.util.Objects;
import java.util.Optional;

public class LongLiteral
extends Literal {
    private final String value;
    private final long parsedValue;

    @Deprecated
    public LongLiteral(String value) {
        this(Optional.empty(), value);
    }

    public LongLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    private LongLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value is null");
        this.parsedValue = NumericParser.parseNumeric(value, location.orElse(new NodeLocation(1, 1)));
    }

    public String getValue() {
        return this.value;
    }

    public long getParsedValue() {
        return this.parsedValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLongLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLiteral that = (LongLiteral)o;
        return this.parsedValue == that.parsedValue;
    }

    @Override
    public int hashCode() {
        return (int)(this.parsedValue ^ this.parsedValue >>> 32);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!LongLiteral.sameClass(this, other)) {
            return false;
        }
        return this.parsedValue == ((LongLiteral)other).parsedValue;
    }
}

