/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DereferenceExpression
extends Expression {
    private final Expression base;
    private final Optional<Identifier> field;

    public DereferenceExpression(Expression base, Identifier field) {
        this(Optional.empty(), base, Optional.of(field));
    }

    public DereferenceExpression(NodeLocation location, Expression base, Identifier field) {
        this(Optional.of(location), base, Optional.of(field));
    }

    public DereferenceExpression(Identifier label) {
        this(Optional.empty(), (Expression)label, Optional.empty());
    }

    public DereferenceExpression(NodeLocation location, Identifier label) {
        this(Optional.of(location), (Expression)label, Optional.empty());
    }

    private DereferenceExpression(Optional<NodeLocation> location, Expression base, Optional<Identifier> field) {
        super(location);
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"base is null");
        Objects.requireNonNull(field, "field is null");
        this.base = base;
        this.field = field;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDereferenceExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add((Object)this.base);
        this.field.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    public Expression getBase() {
        return this.base;
    }

    public Optional<Identifier> getField() {
        return this.field;
    }

    public static QualifiedName getQualifiedName(DereferenceExpression expression) {
        if (!expression.field.isPresent()) {
            return null;
        }
        Identifier field = expression.field.get();
        ImmutableList parts = null;
        Expression expression2 = expression.base;
        if (expression2 instanceof Identifier) {
            Identifier identifier = (Identifier)expression2;
            parts = ImmutableList.of((Object)identifier, (Object)field);
        } else {
            DereferenceExpression dereferenceExpression;
            QualifiedName baseQualifiedName;
            expression2 = expression.base;
            if (expression2 instanceof DereferenceExpression && (baseQualifiedName = DereferenceExpression.getQualifiedName(dereferenceExpression = (DereferenceExpression)expression2)) != null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll(baseQualifiedName.getOriginalParts());
                builder.add((Object)field);
                parts = builder.build();
            }
        }
        return parts == null ? null : QualifiedName.of((Iterable<Identifier>)parts);
    }

    public static Expression from(QualifiedName name) {
        Expression result = null;
        for (String part : name.getParts()) {
            if (result == null) {
                result = new Identifier(part);
                continue;
            }
            result = new DereferenceExpression(result, new Identifier(part));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isQualifiedAllFieldsReference(Expression expression) {
        if (!(expression instanceof DereferenceExpression)) return false;
        DereferenceExpression dereferenceExpression = (DereferenceExpression)expression;
        if (dereferenceExpression.field.isPresent()) return false;
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DereferenceExpression that = (DereferenceExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.field, that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.field);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return DereferenceExpression.sameClass(this, other);
    }
}

