/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ExplainAnalyze
extends Statement {
    private final Statement statement;
    private final boolean verbose;

    @Deprecated
    public ExplainAnalyze(Statement statement, boolean verbose) {
        super(Optional.empty());
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.verbose = verbose;
    }

    public ExplainAnalyze(NodeLocation location, Statement statement, boolean verbose) {
        super(location);
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.verbose = verbose;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplainAnalyze(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.statement);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statement, this.verbose);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExplainAnalyze o = (ExplainAnalyze)obj;
        return Objects.equals(this.statement, o.statement);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statement", (Object)this.statement).add("verbose", this.verbose).toString();
    }
}

