/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ExplainOption;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Explain
extends Statement {
    private final Statement statement;
    private final List<ExplainOption> options;

    @Deprecated
    public Explain(Statement statement, List<ExplainOption> options) {
        super(Optional.empty());
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.options = ImmutableList.copyOf((Collection)Objects.requireNonNull(options, "options is null"));
    }

    public Explain(NodeLocation location, Statement statement, List<ExplainOption> options) {
        super(location);
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.options = ImmutableList.copyOf(options);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public List<ExplainOption> getOptions() {
        return this.options;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().add((Object)this.statement).addAll(this.options).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statement, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Explain o = (Explain)obj;
        return Objects.equals(this.statement, o.statement) && Objects.equals(this.options, o.options);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statement", (Object)this.statement).add("options", this.options).toString();
    }
}

