/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.VariableDeclaration;
import java.util.List;
import java.util.Objects;

public final class CompoundStatement
extends ControlStatement {
    private final List<VariableDeclaration> variableDeclarations;
    private final List<ControlStatement> statements;

    public CompoundStatement(NodeLocation location, List<VariableDeclaration> variableDeclarations, List<ControlStatement> statements) {
        super(location);
        this.variableDeclarations = Objects.requireNonNull(variableDeclarations, "variableDeclarations is null");
        this.statements = Objects.requireNonNull(statements, "statements is null");
    }

    public List<ControlStatement> getStatements() {
        return this.statements;
    }

    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCompoundStatement(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.builder().addAll(this.statements).addAll(this.variableDeclarations).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompoundStatement)) return false;
        CompoundStatement other = (CompoundStatement)obj;
        if (!Objects.equals(this.variableDeclarations, other.variableDeclarations)) return false;
        if (!Objects.equals(this.statements, other.statements)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.variableDeclarations, this.statements);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("variableDeclarations", this.variableDeclarations).add("statements", this.statements).toString();
    }
}

