/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NestedColumns
extends JsonTableColumnDefinition {
    private final StringLiteral jsonPath;
    private final Optional<Identifier> pathName;
    private final List<JsonTableColumnDefinition> columns;

    public NestedColumns(NodeLocation location, StringLiteral jsonPath, Optional<Identifier> pathName, List<JsonTableColumnDefinition> columns) {
        super(location);
        this.jsonPath = Objects.requireNonNull(jsonPath, "jsonPath is null");
        this.pathName = Objects.requireNonNull(pathName, "pathName is null");
        this.columns = ImmutableList.copyOf(columns);
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"columns is empty");
    }

    public StringLiteral getJsonPath() {
        return this.jsonPath;
    }

    public Optional<Identifier> getPathName() {
        return this.pathName;
    }

    public List<JsonTableColumnDefinition> getColumns() {
        return this.columns;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNestedColumns(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.builder().add((Object)this.jsonPath).addAll(this.columns).build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jsonPath", (Object)this.jsonPath).add("pathName", this.pathName.orElse(null)).add("columns", this.columns).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedColumns that = (NestedColumns)o;
        return Objects.equals(this.jsonPath, that.jsonPath) && Objects.equals(this.pathName, that.pathName) && Objects.equals(this.columns, that.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.jsonPath, this.pathName, this.columns);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!NestedColumns.sameClass(this, other)) {
            return false;
        }
        return this.pathName.equals(((NestedColumns)other).pathName);
    }
}

