/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Execute
extends Statement {
    private final Identifier name;
    private final List<Expression> parameters;

    public Execute(NodeLocation location, Identifier name, List<Expression> parameters) {
        super(Optional.of(location));
        this.name = Objects.requireNonNull(name, "name is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
    }

    public Identifier getName() {
        return this.name;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExecute(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.parameters;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parameters);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Execute o = (Execute)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.parameters, o.parameters);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("parameters", this.parameters).toString();
    }
}

