/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropView
extends Statement {
    private final QualifiedName name;
    private final boolean exists;

    public DropView(NodeLocation location, QualifiedName name, boolean exists) {
        super(Optional.of(location));
        this.name = name;
        this.exists = exists;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropView o = (DropView)obj;
        return Objects.equals(this.name, o.name) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("exists", this.exists).toString();
    }
}

