/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.ExpressionFormatter;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonPathInvocation
extends Node {
    private final Expression inputExpression;
    private final JsonPathParameter.JsonFormat inputFormat;
    private final StringLiteral jsonPath;
    private final Optional<Identifier> pathName;
    private final List<JsonPathParameter> pathParameters;

    public JsonPathInvocation(Optional<NodeLocation> location, Expression inputExpression, JsonPathParameter.JsonFormat inputFormat, StringLiteral jsonPath, Optional<Identifier> pathName, List<JsonPathParameter> pathParameters) {
        super(location);
        Objects.requireNonNull(inputExpression, "inputExpression is null");
        Objects.requireNonNull(inputFormat, "inputFormat is null");
        Objects.requireNonNull(jsonPath, "jsonPath is null");
        Objects.requireNonNull(pathName, "pathName is null");
        Objects.requireNonNull(pathParameters, "pathParameters is null");
        this.inputExpression = inputExpression;
        this.inputFormat = inputFormat;
        this.jsonPath = jsonPath;
        this.pathName = pathName;
        this.pathParameters = ImmutableList.copyOf(pathParameters);
    }

    public Expression getInputExpression() {
        return this.inputExpression;
    }

    public JsonPathParameter.JsonFormat getInputFormat() {
        return this.inputFormat;
    }

    public StringLiteral getJsonPath() {
        return this.jsonPath;
    }

    public Optional<Identifier> getPathName() {
        return this.pathName;
    }

    public List<JsonPathParameter> getPathParameters() {
        return this.pathParameters;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonPathInvocation(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add((Object)this.inputExpression);
        children.add((Object)this.jsonPath);
        this.pathParameters.forEach(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPathInvocation that = (JsonPathInvocation)o;
        return Objects.equals(this.inputExpression, that.inputExpression) && this.inputFormat == that.inputFormat && Objects.equals(this.jsonPath, that.jsonPath) && Objects.equals(this.pathName, that.pathName) && Objects.equals(this.pathParameters, that.pathParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.inputExpression, this.inputFormat, this.jsonPath, this.pathName, this.pathParameters});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonPathInvocation.sameClass(this, other)) {
            return false;
        }
        JsonPathInvocation otherInvocation = (JsonPathInvocation)other;
        return this.inputFormat == otherInvocation.inputFormat && this.pathName.equals(otherInvocation.getPathName());
    }

    @Override
    public String toString() {
        return ExpressionFormatter.formatJsonPathInvocation(this);
    }
}

