/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LogicalExpression
extends Expression {
    private final Operator operator;
    private final List<Expression> terms;

    public LogicalExpression(Operator operator, List<Expression> terms) {
        this(Optional.empty(), operator, terms);
    }

    public LogicalExpression(NodeLocation location, Operator operator, List<Expression> terms) {
        this(Optional.of(location), operator, terms);
    }

    private LogicalExpression(Optional<NodeLocation> location, Operator operator, List<Expression> terms) {
        super(location);
        Objects.requireNonNull(operator, "operator is null");
        Preconditions.checkArgument((terms.size() >= 2 ? 1 : 0) != 0, (Object)"Expected at least 2 terms");
        this.operator = operator;
        this.terms = ImmutableList.copyOf(terms);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Expression> getTerms() {
        return this.terms;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLogicalExpression(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.terms;
    }

    public static LogicalExpression and(Expression left, Expression right) {
        return new LogicalExpression(Optional.empty(), Operator.AND, (List<Expression>)ImmutableList.of((Object)left, (Object)right));
    }

    public static LogicalExpression or(Expression left, Expression right) {
        return new LogicalExpression(Optional.empty(), Operator.OR, (List<Expression>)ImmutableList.of((Object)left, (Object)right));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalExpression that = (LogicalExpression)o;
        return this.operator == that.operator && Objects.equals(this.terms, that.terms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.terms});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!LogicalExpression.sameClass(this, other)) {
            return false;
        }
        return this.operator == ((LogicalExpression)other).operator;
    }

    public static enum Operator {
        AND,
        OR;


        public Operator flip() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OR;
                case 1 -> AND;
            };
        }
    }
}

