/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateView
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean replace;
    private final Optional<String> comment;
    private final Optional<Security> security;
    private final List<Property> properties;

    public CreateView(QualifiedName name, Query query, boolean replace, Optional<String> comment, Optional<Security> security, List<Property> properties) {
        this(Optional.empty(), name, query, replace, comment, security, properties);
    }

    public CreateView(NodeLocation location, QualifiedName name, Query query, boolean replace, Optional<String> comment, Optional<Security> security, List<Property> properties) {
        this(Optional.of(location), name, query, replace, comment, security, properties);
    }

    private CreateView(Optional<NodeLocation> location, QualifiedName name, Query query, boolean replace, Optional<String> comment, Optional<Security> security, List<Property> properties) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.replace = replace;
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.security = Objects.requireNonNull(security, "security is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Optional<Security> getSecurity() {
        return this.security;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().add((Object)this.query).addAll(this.properties).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.replace, this.security, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateView o = (CreateView)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && this.replace == o.replace && Objects.equals(this.comment, o.comment) && Objects.equals(this.security, o.security) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("replace", this.replace).add("comment", this.comment).add("security", this.security).add("properties", this.properties).toString();
    }

    public static enum Security {
        INVOKER,
        DEFINER;

    }
}

