/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class BooleanLiteral
extends Literal {
    public static final BooleanLiteral TRUE_LITERAL = new BooleanLiteral(Optional.empty(), "true");
    public static final BooleanLiteral FALSE_LITERAL = new BooleanLiteral(Optional.empty(), "false");
    private final boolean value;

    public BooleanLiteral(String value) {
        this(Optional.empty(), value);
    }

    public BooleanLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    private BooleanLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((value.toLowerCase(Locale.ENGLISH).equals("true") || value.toLowerCase(Locale.ENGLISH).equals("false") ? 1 : 0) != 0);
        this.value = value.toLowerCase(Locale.ENGLISH).equals("true");
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBooleanLiteral(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanLiteral other = (BooleanLiteral)obj;
        return this.value == other.value;
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!BooleanLiteral.sameClass(this, other)) {
            return false;
        }
        return this.value == ((BooleanLiteral)other).value;
    }
}

