/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GrantObject
extends Node {
    private final Optional<String> entityKind;
    private final QualifiedName name;

    public GrantObject(NodeLocation location, Optional<String> entityKind, QualifiedName name) {
        super(Optional.of(location));
        this.entityKind = Objects.requireNonNull(entityKind, "entityKind is null");
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Optional<String> getEntityKind() {
        return this.entityKind;
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantObject that = (GrantObject)o;
        return Objects.equals(this.entityKind, that.entityKind) && Objects.equals(this.name, that.name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityKind", this.entityKind).add("qualifiedName", (Object)this.name).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityKind, this.name);
    }
}

