/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropNotNullConstraint
extends Statement {
    private final QualifiedName table;
    private final Identifier column;
    private final boolean tableExists;

    public DropNotNullConstraint(NodeLocation location, QualifiedName table, Identifier column, boolean tableExists) {
        super(Optional.of(location));
        this.table = Objects.requireNonNull(table, "table is null");
        this.column = Objects.requireNonNull(column, "field is null");
        this.tableExists = tableExists;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Identifier getColumn() {
        return this.column;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropNotNullConstraint(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.column);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropNotNullConstraint that = (DropNotNullConstraint)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.column, that.column);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.column);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("column", (Object)this.column).toString();
    }
}

