/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.ReservedIdentifiers;
import io.trino.sql.RowPatternFormatter;
import io.trino.sql.SqlFormatter;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.AllRows;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentDate;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentTimestamp;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DateTimeDataType;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.GroupingElement;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.GroupingSets;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IntervalDayTimeDataType;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LocalTime;
import io.trino.sql.tree.LocalTimestamp;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.NumericParameter;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SimpleGroupBy;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.TypeParameter;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ExpressionFormatter {
    private static final ThreadLocal<DecimalFormat> doubleFormatter = ThreadLocal.withInitial(() -> new DecimalFormat("0.###################E0###", new DecimalFormatSymbols(Locale.US)));

    private ExpressionFormatter() {
    }

    public static String formatExpression(Expression expression) {
        return (String)new Formatter(Optional.empty()).process(expression, null);
    }

    private static String formatIdentifier(String s) {
        return "\"" + s.replace("\"", "\"\"") + "\"";
    }

    static String formatStringLiteral(String s) {
        return "'" + s.replace("'", "''") + "'";
    }

    public static String formatOrderBy(OrderBy orderBy) {
        return "ORDER BY " + ExpressionFormatter.formatSortItems(orderBy.getSortItems());
    }

    public static String formatSortItems(List<SortItem> sortItems) {
        return sortItems.stream().map(ExpressionFormatter.sortItemFormatterFunction()).collect(Collectors.joining(", "));
    }

    private static String formatWindow(Window window) {
        if (window instanceof WindowReference) {
            return ExpressionFormatter.formatExpression(((WindowReference)window).getName());
        }
        return ExpressionFormatter.formatWindowSpecification((WindowSpecification)window);
    }

    static String formatWindowSpecification(WindowSpecification windowSpecification) {
        ArrayList<Object> parts = new ArrayList<Object>();
        if (windowSpecification.getExistingWindowName().isPresent()) {
            parts.add(ExpressionFormatter.formatExpression(windowSpecification.getExistingWindowName().get()));
        }
        if (!windowSpecification.getPartitionBy().isEmpty()) {
            parts.add("PARTITION BY " + windowSpecification.getPartitionBy().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", ")));
        }
        if (windowSpecification.getOrderBy().isPresent()) {
            parts.add(ExpressionFormatter.formatOrderBy(windowSpecification.getOrderBy().get()));
        }
        if (windowSpecification.getFrame().isPresent()) {
            parts.add(ExpressionFormatter.formatFrame(windowSpecification.getFrame().get()));
        }
        return "(" + Joiner.on((char)' ').join(parts) + ")";
    }

    private static String formatFrame(WindowFrame windowFrame) {
        StringBuilder builder = new StringBuilder();
        if (!windowFrame.getMeasures().isEmpty()) {
            builder.append("MEASURES ").append(windowFrame.getMeasures().stream().map(measure -> ExpressionFormatter.formatExpression(measure.getExpression()) + " AS " + ExpressionFormatter.formatExpression(measure.getName())).collect(Collectors.joining(", "))).append(" ");
        }
        builder.append(windowFrame.getType().toString()).append(' ');
        if (windowFrame.getEnd().isPresent()) {
            builder.append("BETWEEN ").append(ExpressionFormatter.formatFrameBound(windowFrame.getStart())).append(" AND ").append(ExpressionFormatter.formatFrameBound(windowFrame.getEnd().get()));
        } else {
            builder.append(ExpressionFormatter.formatFrameBound(windowFrame.getStart()));
        }
        windowFrame.getAfterMatchSkipTo().ifPresent(skipTo -> builder.append(" ").append(ExpressionFormatter.formatSkipTo(skipTo)));
        windowFrame.getPatternSearchMode().ifPresent(searchMode -> builder.append(" ").append(searchMode.getMode().name()));
        windowFrame.getPattern().ifPresent(pattern -> builder.append(" PATTERN(").append(RowPatternFormatter.formatPattern(pattern)).append(")"));
        if (!windowFrame.getSubsets().isEmpty()) {
            builder.append(" SUBSET ");
            builder.append(windowFrame.getSubsets().stream().map(subset -> ExpressionFormatter.formatExpression(subset.getName()) + " = " + subset.getIdentifiers().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.joining(", ")));
        }
        if (!windowFrame.getVariableDefinitions().isEmpty()) {
            builder.append(" DEFINE ");
            builder.append(windowFrame.getVariableDefinitions().stream().map(variable -> ExpressionFormatter.formatExpression(variable.getName()) + " AS " + ExpressionFormatter.formatExpression(variable.getExpression())).collect(Collectors.joining(", ")));
        }
        return builder.toString();
    }

    private static String formatFrameBound(FrameBound frameBound) {
        return switch (frameBound.getType()) {
            default -> throw new MatchException(null, null);
            case FrameBound.Type.UNBOUNDED_PRECEDING -> "UNBOUNDED PRECEDING";
            case FrameBound.Type.PRECEDING -> ExpressionFormatter.formatExpression(frameBound.getValue().get()) + " PRECEDING";
            case FrameBound.Type.CURRENT_ROW -> "CURRENT ROW";
            case FrameBound.Type.FOLLOWING -> ExpressionFormatter.formatExpression(frameBound.getValue().get()) + " FOLLOWING";
            case FrameBound.Type.UNBOUNDED_FOLLOWING -> "UNBOUNDED FOLLOWING";
        };
    }

    public static String formatSkipTo(SkipTo skipTo) {
        return switch (skipTo.getPosition()) {
            default -> throw new MatchException(null, null);
            case SkipTo.Position.PAST_LAST -> "AFTER MATCH SKIP PAST LAST ROW";
            case SkipTo.Position.NEXT -> "AFTER MATCH SKIP TO NEXT ROW";
            case SkipTo.Position.LAST -> {
                Preconditions.checkState((boolean)skipTo.getIdentifier().isPresent(), (Object)"missing identifier in AFTER MATCH SKIP TO LAST");
                yield "AFTER MATCH SKIP TO LAST " + ExpressionFormatter.formatExpression(skipTo.getIdentifier().get());
            }
            case SkipTo.Position.FIRST -> {
                Preconditions.checkState((boolean)skipTo.getIdentifier().isPresent(), (Object)"missing identifier in AFTER MATCH SKIP TO FIRST");
                yield "AFTER MATCH SKIP TO FIRST " + ExpressionFormatter.formatExpression(skipTo.getIdentifier().get());
            }
        };
    }

    static String formatGroupBy(List<GroupingElement> groupingElements) {
        return groupingElements.stream().map(groupingElement -> {
            String result = "";
            if (groupingElement instanceof SimpleGroupBy) {
                List<Expression> columns = groupingElement.getExpressions();
                result = columns.size() == 1 ? ExpressionFormatter.formatExpression((Expression)Iterables.getOnlyElement(columns)) : ExpressionFormatter.formatGroupingSet(columns);
            } else if (groupingElement instanceof GroupingSets) {
                GroupingSets groupingSets = (GroupingSets)groupingElement;
                String type = switch (groupingSets.getType()) {
                    default -> throw new MatchException(null, null);
                    case GroupingSets.Type.EXPLICIT -> "GROUPING SETS";
                    case GroupingSets.Type.CUBE -> "CUBE";
                    case GroupingSets.Type.ROLLUP -> "ROLLUP";
                };
                result = groupingSets.getSets().stream().map(ExpressionFormatter::formatGroupingSet).collect(Collectors.joining(", ", type + " (", ")"));
            }
            return result;
        }).collect(Collectors.joining(", "));
    }

    private static boolean isAsciiPrintable(int codePoint) {
        return codePoint >= 32 && codePoint < 127;
    }

    private static String formatGroupingSet(List<Expression> groupingSet) {
        return groupingSet.stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", ", "(", ")"));
    }

    private static Function<SortItem, String> sortItemFormatterFunction() {
        return input -> {
            StringBuilder builder = new StringBuilder();
            builder.append(ExpressionFormatter.formatExpression(input.getSortKey()));
            builder.append(switch (input.getOrdering()) {
                default -> throw new MatchException(null, null);
                case SortItem.Ordering.ASCENDING -> " ASC";
                case SortItem.Ordering.DESCENDING -> " DESC";
            });
            builder.append(switch (input.getNullOrdering()) {
                default -> throw new MatchException(null, null);
                case SortItem.NullOrdering.FIRST -> " NULLS FIRST";
                case SortItem.NullOrdering.LAST -> " NULLS LAST";
                case SortItem.NullOrdering.UNDEFINED -> "";
            });
            return builder.toString();
        };
    }

    public static String formatJsonPathInvocation(JsonPathInvocation pathInvocation) {
        StringBuilder builder = new StringBuilder();
        builder.append(ExpressionFormatter.formatJsonExpression(pathInvocation.getInputExpression(), Optional.of(pathInvocation.getInputFormat()))).append(", ").append(ExpressionFormatter.formatExpression(pathInvocation.getJsonPath()));
        pathInvocation.getPathName().ifPresent(pathName -> builder.append(" AS ").append(ExpressionFormatter.formatExpression(pathName)));
        if (!pathInvocation.getPathParameters().isEmpty()) {
            builder.append(" PASSING ");
            builder.append(ExpressionFormatter.formatJsonPathParameters(pathInvocation.getPathParameters()));
        }
        return builder.toString();
    }

    private static String formatJsonExpression(Expression expression, Optional<JsonPathParameter.JsonFormat> format) {
        return ExpressionFormatter.formatExpression(expression) + format.map(jsonFormat -> " FORMAT " + String.valueOf(jsonFormat)).orElse("");
    }

    private static String formatJsonPathParameters(List<JsonPathParameter> parameters) {
        return parameters.stream().map(parameter -> ExpressionFormatter.formatJsonExpression(parameter.getParameter(), parameter.getFormat()) + " AS " + ExpressionFormatter.formatExpression(parameter.getName())).collect(Collectors.joining(", "));
    }

    public static class Formatter
    extends AstVisitor<String, Void> {
        private final Optional<Function<Literal, String>> literalFormatter;

        public Formatter(Optional<Function<Literal, String>> literalFormatter) {
            this.literalFormatter = Objects.requireNonNull(literalFormatter, "literalFormatter is null");
        }

        @Override
        protected String visitNode(Node node, Void context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String visitRow(Row node, Void context) {
            return node.getItems().stream().map(child -> (String)this.process((Node)child, context)).collect(Collectors.joining(", ", "ROW (", ")"));
        }

        @Override
        protected String visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: %s.visit%s".formatted(this.getClass().getName(), node.getClass().getSimpleName()));
        }

        @Override
        protected String visitAtTimeZone(AtTimeZone node, Void context) {
            return (String)this.process(node.getValue(), context) + " AT TIME ZONE " + (String)this.process(node.getTimeZone(), context);
        }

        @Override
        protected String visitCurrentCatalog(CurrentCatalog node, Void context) {
            return "CURRENT_CATALOG";
        }

        @Override
        protected String visitCurrentSchema(CurrentSchema node, Void context) {
            return "CURRENT_SCHEMA";
        }

        @Override
        protected String visitCurrentUser(CurrentUser node, Void context) {
            return "CURRENT_USER";
        }

        @Override
        protected String visitCurrentPath(CurrentPath node, Void context) {
            return "CURRENT_PATH";
        }

        @Override
        protected String visitTrim(Trim node, Void context) {
            if (!node.getTrimCharacter().isPresent()) {
                return "trim(%s FROM %s)".formatted(new Object[]{node.getSpecification(), this.process(node.getTrimSource(), context)});
            }
            return "trim(%s %s FROM %s)".formatted(new Object[]{node.getSpecification(), this.process(node.getTrimCharacter().get(), context), this.process(node.getTrimSource(), context)});
        }

        @Override
        protected String visitFormat(Format node, Void context) {
            return "format(" + this.joinExpressions(node.getArguments()) + ")";
        }

        @Override
        protected String visitCurrentDate(CurrentDate node, Void context) {
            return "current_date";
        }

        @Override
        protected String visitCurrentTime(CurrentTime node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("current_time");
            node.getPrecision().ifPresent(precision -> builder.append('(').append(precision).append(')'));
            return builder.toString();
        }

        @Override
        protected String visitCurrentTimestamp(CurrentTimestamp node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("current_timestamp");
            node.getPrecision().ifPresent(precision -> builder.append('(').append(precision).append(')'));
            return builder.toString();
        }

        @Override
        protected String visitLocalTime(LocalTime node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("localtime");
            node.getPrecision().ifPresent(precision -> builder.append('(').append(precision).append(')'));
            return builder.toString();
        }

        @Override
        protected String visitLocalTimestamp(LocalTimestamp node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("localtimestamp");
            node.getPrecision().ifPresent(precision -> builder.append('(').append(precision).append(')'));
            return builder.toString();
        }

        @Override
        protected String visitExtract(Extract node, Void context) {
            return "EXTRACT(" + String.valueOf((Object)node.getField()) + " FROM " + (String)this.process(node.getExpression(), context) + ")";
        }

        @Override
        protected String visitBooleanLiteral(BooleanLiteral node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElseGet(() -> String.valueOf(node.getValue()));
        }

        @Override
        protected String visitStringLiteral(StringLiteral node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElseGet(() -> ExpressionFormatter.formatStringLiteral(node.getValue()));
        }

        @Override
        protected String visitBinaryLiteral(BinaryLiteral node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElseGet(() -> "X'" + node.toHexString() + "'");
        }

        @Override
        protected String visitParameter(Parameter node, Void context) {
            return "?";
        }

        @Override
        protected String visitAllRows(AllRows node, Void context) {
            return "ALL";
        }

        @Override
        protected String visitArray(Array node, Void context) {
            return node.getValues().stream().map(SqlFormatter::formatSql).collect(Collectors.joining(",", "ARRAY[", "]"));
        }

        @Override
        protected String visitSubscriptExpression(SubscriptExpression node, Void context) {
            return SqlFormatter.formatSql(node.getBase()) + "[" + SqlFormatter.formatSql(node.getIndex()) + "]";
        }

        @Override
        protected String visitLongLiteral(LongLiteral node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElseGet(node::getValue);
        }

        @Override
        protected String visitDoubleLiteral(DoubleLiteral node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElseGet(() -> doubleFormatter.get().format(node.getValue()));
        }

        @Override
        protected String visitDecimalLiteral(DecimalLiteral node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElseGet(() -> "DECIMAL '" + node.getValue() + "'");
        }

        @Override
        protected String visitGenericLiteral(GenericLiteral node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElseGet(() -> node.getType() + " " + ExpressionFormatter.formatStringLiteral(node.getValue()));
        }

        @Override
        protected String visitNullLiteral(NullLiteral node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElse("null");
        }

        @Override
        protected String visitIntervalLiteral(IntervalLiteral node, Void context) {
            if (this.literalFormatter.isPresent()) {
                return this.literalFormatter.get().apply(node);
            }
            String sign = node.getSign() == IntervalLiteral.Sign.NEGATIVE ? "-" : "";
            StringBuilder builder = new StringBuilder().append("INTERVAL ").append(sign).append("'").append(node.getValue()).append("' ").append((Object)node.getStartField());
            if (node.getEndField().isPresent()) {
                builder.append(" TO ").append((Object)node.getEndField().get());
            }
            return builder.toString();
        }

        @Override
        protected String visitSubqueryExpression(SubqueryExpression node, Void context) {
            return "(" + SqlFormatter.formatSql(node.getQuery()) + ")";
        }

        @Override
        protected String visitExists(ExistsPredicate node, Void context) {
            return "(EXISTS " + SqlFormatter.formatSql(node.getSubquery()) + ")";
        }

        @Override
        protected String visitIdentifier(Identifier node, Void context) {
            if (node.isDelimited() || ReservedIdentifiers.reserved(node.getValue())) {
                return "\"" + node.getValue().replace("\"", "\"\"") + "\"";
            }
            return node.getValue();
        }

        @Override
        protected String visitLambdaArgumentDeclaration(LambdaArgumentDeclaration node, Void context) {
            return ExpressionFormatter.formatExpression(node.getName());
        }

        @Override
        protected String visitDereferenceExpression(DereferenceExpression node, Void context) {
            String baseString = (String)this.process(node.getBase(), context);
            return baseString + "." + node.getField().map(this::process).orElse("*");
        }

        @Override
        public String visitFieldReference(FieldReference node, Void context) {
            return ":input(" + node.getFieldIndex() + ")";
        }

        @Override
        protected String visitFunctionCall(FunctionCall node, Void context) {
            if (QualifiedName.of("LISTAGG").equals(node.getName())) {
                return this.visitListagg(node);
            }
            StringBuilder builder = new StringBuilder();
            if (node.getProcessingMode().isPresent()) {
                builder.append((Object)node.getProcessingMode().get().getMode()).append(" ");
            }
            Object arguments = this.joinExpressions(node.getArguments());
            if (node.getArguments().isEmpty() && "count".equalsIgnoreCase(node.getName().getSuffix())) {
                arguments = "*";
            }
            if (node.isDistinct()) {
                arguments = "DISTINCT " + (String)arguments;
            }
            builder.append(SqlFormatter.formatName(node.getName())).append('(').append((String)arguments);
            if (node.getOrderBy().isPresent()) {
                builder.append(' ').append(ExpressionFormatter.formatOrderBy(node.getOrderBy().get()));
            }
            builder.append(')');
            node.getNullTreatment().ifPresent(nullTreatment -> builder.append(switch (nullTreatment) {
                default -> throw new MatchException(null, null);
                case FunctionCall.NullTreatment.IGNORE -> " IGNORE NULLS";
                case FunctionCall.NullTreatment.RESPECT -> " RESPECT NULLS";
            }));
            if (node.getFilter().isPresent()) {
                builder.append(" FILTER ").append(this.visitFilter(node.getFilter().get(), context));
            }
            if (node.getWindow().isPresent()) {
                builder.append(" OVER ").append(ExpressionFormatter.formatWindow(node.getWindow().get()));
            }
            return builder.toString();
        }

        @Override
        protected String visitWindowOperation(WindowOperation node, Void context) {
            return (String)this.process(node.getName(), context) + " OVER " + ExpressionFormatter.formatWindow(node.getWindow());
        }

        @Override
        protected String visitLambdaExpression(LambdaExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            Joiner.on((String)", ").appendTo(builder, node.getArguments());
            builder.append(") -> ");
            builder.append((String)this.process(node.getBody(), context));
            return builder.toString();
        }

        @Override
        protected String visitLogicalExpression(LogicalExpression node, Void context) {
            return "(" + node.getTerms().stream().map(term -> (String)this.process((Node)term, context)).collect(Collectors.joining(" " + node.getOperator().toString() + " ")) + ")";
        }

        @Override
        protected String visitNotExpression(NotExpression node, Void context) {
            return "(NOT " + (String)this.process(node.getValue(), context) + ")";
        }

        @Override
        protected String visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().getValue(), node.getLeft(), node.getRight());
        }

        @Override
        protected String visitIsNullPredicate(IsNullPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " IS NULL)";
        }

        @Override
        protected String visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " IS NOT NULL)";
        }

        @Override
        protected String visitNullIfExpression(NullIfExpression node, Void context) {
            return "NULLIF(" + (String)this.process(node.getFirst(), context) + ", " + (String)this.process(node.getSecond(), context) + ")";
        }

        @Override
        protected String visitIfExpression(IfExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("IF(").append((String)this.process(node.getCondition(), context)).append(", ").append((String)this.process(node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                builder.append(", ").append((String)this.process(node.getFalseValue().get(), context));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        protected String visitTryExpression(TryExpression node, Void context) {
            return "TRY(" + (String)this.process(node.getInnerExpression(), context) + ")";
        }

        @Override
        protected String visitCoalesceExpression(CoalesceExpression node, Void context) {
            return "COALESCE(" + this.joinExpressions(node.getOperands()) + ")";
        }

        @Override
        protected String visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            String value = (String)this.process(node.getValue(), context);
            return switch (node.getSign()) {
                default -> throw new MatchException(null, null);
                case ArithmeticUnaryExpression.Sign.MINUS -> "-(" + value + ")";
                case ArithmeticUnaryExpression.Sign.PLUS -> "+" + value;
            };
        }

        @Override
        protected String visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().getValue(), node.getLeft(), node.getRight());
        }

        @Override
        protected String visitLikePredicate(LikePredicate node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append('(').append((String)this.process(node.getValue(), context)).append(" LIKE ").append((String)this.process(node.getPattern(), context));
            node.getEscape().ifPresent(escape -> builder.append(" ESCAPE ").append((String)this.process((Node)escape, context)));
            builder.append(')');
            return builder.toString();
        }

        @Override
        protected String visitAllColumns(AllColumns node, Void context) {
            StringBuilder builder = new StringBuilder();
            if (node.getTarget().isPresent()) {
                builder.append((String)this.process(node.getTarget().get(), context));
                builder.append(".*");
            } else {
                builder.append("*");
            }
            if (!node.getAliases().isEmpty()) {
                builder.append(" AS (");
                Joiner.on((String)", ").appendTo(builder, (Iterable)node.getAliases().stream().map(alias -> (String)this.process((Node)alias, context)).collect(Collectors.toList()));
                builder.append(")");
            }
            return builder.toString();
        }

        @Override
        public String visitCast(Cast node, Void context) {
            return (node.isSafe() ? "TRY_CAST" : "CAST") + "(" + (String)this.process(node.getExpression(), context) + " AS " + (String)this.process(node.getType(), context) + ")";
        }

        @Override
        protected String visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE");
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add((Object)((String)this.process(whenClause, context)));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add((Object)((String)this.process((Node)value, context))));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE").add((Object)((String)this.process(node.getOperand(), context)));
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add((Object)((String)this.process(whenClause, context)));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add((Object)((String)this.process((Node)value, context))));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitWhenClause(WhenClause node, Void context) {
            return "WHEN " + (String)this.process(node.getOperand(), context) + " THEN " + (String)this.process(node.getResult(), context);
        }

        @Override
        protected String visitBetweenPredicate(BetweenPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " BETWEEN " + (String)this.process(node.getMin(), context) + " AND " + (String)this.process(node.getMax(), context) + ")";
        }

        @Override
        protected String visitInPredicate(InPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " IN " + (String)this.process(node.getValueList(), context) + ")";
        }

        @Override
        protected String visitInListExpression(InListExpression node, Void context) {
            return "(" + this.joinExpressions(node.getValues()) + ")";
        }

        private String visitFilter(Expression node, Void context) {
            return "(WHERE " + (String)this.process(node, context) + ")";
        }

        @Override
        protected String visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Void context) {
            return "(%s %s %s %s)".formatted(new Object[]{this.process(node.getValue(), context), node.getOperator().getValue(), node.getQuantifier(), this.process(node.getSubquery(), context)});
        }

        @Override
        protected String visitGroupingOperation(GroupingOperation node, Void context) {
            return "GROUPING (" + this.joinExpressions(node.getGroupingColumns()) + ")";
        }

        @Override
        protected String visitRowDataType(RowDataType node, Void context) {
            return node.getFields().stream().map(this::process).collect(Collectors.joining(", ", "ROW(", ")"));
        }

        @Override
        protected String visitRowField(RowDataType.Field node, Void context) {
            StringBuilder result = new StringBuilder();
            if (node.getName().isPresent()) {
                result.append((String)this.process(node.getName().get(), context));
                result.append(" ");
            }
            result.append((String)this.process(node.getType(), context));
            return result.toString();
        }

        @Override
        protected String visitGenericDataType(GenericDataType node, Void context) {
            StringBuilder result = new StringBuilder();
            result.append(node.getName());
            if (!node.getArguments().isEmpty()) {
                result.append(node.getArguments().stream().map(this::process).collect(Collectors.joining(", ", "(", ")")));
            }
            return result.toString();
        }

        @Override
        protected String visitTypeParameter(TypeParameter node, Void context) {
            return (String)this.process(node.getValue(), context);
        }

        @Override
        protected String visitNumericTypeParameter(NumericParameter node, Void context) {
            return node.getValue();
        }

        @Override
        protected String visitIntervalDataType(IntervalDayTimeDataType node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("INTERVAL ");
            builder.append((Object)node.getFrom());
            if (node.getFrom() != node.getTo()) {
                builder.append(" TO ").append((Object)node.getTo());
            }
            return builder.toString();
        }

        @Override
        protected String visitDateTimeType(DateTimeDataType node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().toString().toLowerCase(Locale.ENGLISH));
            if (node.getPrecision().isPresent()) {
                builder.append("(").append(node.getPrecision().get()).append(")");
            }
            if (node.isWithTimeZone()) {
                builder.append(" with time zone");
            }
            return builder.toString();
        }

        @Override
        protected String visitJsonExists(JsonExists node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("JSON_EXISTS(").append(ExpressionFormatter.formatJsonPathInvocation(node.getJsonPathInvocation())).append(" ").append((Object)node.getErrorBehavior()).append(" ON ERROR").append(")");
            return builder.toString();
        }

        @Override
        protected String visitJsonValue(JsonValue node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("JSON_VALUE(").append(ExpressionFormatter.formatJsonPathInvocation(node.getJsonPathInvocation()));
            if (node.getReturnedType().isPresent()) {
                builder.append(" RETURNING ").append((String)this.process(node.getReturnedType().get()));
            }
            builder.append(" ").append((Object)node.getEmptyBehavior()).append(node.getEmptyDefault().map(expression -> " " + (String)this.process((Node)expression)).orElse("")).append(" ON EMPTY ").append((Object)node.getErrorBehavior()).append(node.getErrorDefault().map(expression -> " " + (String)this.process((Node)expression)).orElse("")).append(" ON ERROR").append(")");
            return builder.toString();
        }

        @Override
        protected String visitJsonQuery(JsonQuery node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("JSON_QUERY(").append(ExpressionFormatter.formatJsonPathInvocation(node.getJsonPathInvocation()));
            if (node.getReturnedType().isPresent()) {
                builder.append(" RETURNING ").append((String)this.process(node.getReturnedType().get())).append(node.getOutputFormat().map(string -> " FORMAT " + String.valueOf(string)).orElse(""));
            }
            builder.append(switch (node.getWrapperBehavior()) {
                default -> throw new MatchException(null, null);
                case JsonQuery.ArrayWrapperBehavior.WITHOUT -> " WITHOUT ARRAY WRAPPER";
                case JsonQuery.ArrayWrapperBehavior.CONDITIONAL -> " WITH CONDITIONAL ARRAY WRAPPER";
                case JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL -> " WITH UNCONDITIONAL ARRAY WRAPPER";
            });
            if (node.getQuotesBehavior().isPresent()) {
                builder.append(switch (node.getQuotesBehavior().get()) {
                    default -> throw new MatchException(null, null);
                    case JsonQuery.QuotesBehavior.KEEP -> " KEEP QUOTES ON SCALAR STRING";
                    case JsonQuery.QuotesBehavior.OMIT -> " OMIT QUOTES ON SCALAR STRING";
                });
            }
            builder.append(" ").append((Object)node.getEmptyBehavior()).append(" ON EMPTY ").append((Object)node.getErrorBehavior()).append(" ON ERROR").append(")");
            return builder.toString();
        }

        @Override
        protected String visitJsonObject(JsonObject node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("JSON_OBJECT(");
            if (!node.getMembers().isEmpty()) {
                builder.append(node.getMembers().stream().map(member -> "KEY " + ExpressionFormatter.formatExpression(member.getKey()) + " VALUE " + ExpressionFormatter.formatJsonExpression(member.getValue(), member.getFormat())).collect(Collectors.joining(", ")));
                builder.append(node.isNullOnNull() ? " NULL ON NULL" : " ABSENT ON NULL");
                builder.append(node.isUniqueKeys() ? " WITH UNIQUE KEYS" : " WITHOUT UNIQUE KEYS");
            }
            if (node.getReturnedType().isPresent()) {
                builder.append(" RETURNING ").append((String)this.process(node.getReturnedType().get())).append(node.getOutputFormat().map(string -> " FORMAT " + String.valueOf(string)).orElse(""));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        protected String visitJsonArray(JsonArray node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("JSON_ARRAY(");
            if (!node.getElements().isEmpty()) {
                builder.append(node.getElements().stream().map(element -> ExpressionFormatter.formatJsonExpression(element.getValue(), element.getFormat())).collect(Collectors.joining(", ")));
                builder.append(node.isNullOnNull() ? " NULL ON NULL" : " ABSENT ON NULL");
            }
            if (node.getReturnedType().isPresent()) {
                builder.append(" RETURNING ").append((String)this.process(node.getReturnedType().get())).append(node.getOutputFormat().map(string -> " FORMAT " + String.valueOf(string)).orElse(""));
            }
            builder.append(")");
            return builder.toString();
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right) {
            return "(" + (String)this.process(left, null) + " " + operator + " " + (String)this.process(right, null) + ")";
        }

        private String joinExpressions(List<Expression> expressions) {
            return expressions.stream().map(e -> (String)this.process((Node)e, null)).collect(Collectors.joining(", "));
        }

        private String visitListagg(FunctionCall node) {
            StringBuilder builder = new StringBuilder();
            List<Expression> arguments = node.getArguments();
            Expression expression = arguments.get(0);
            Expression separator = arguments.get(1);
            BooleanLiteral overflowError = (BooleanLiteral)arguments.get(2);
            Expression overflowFiller = arguments.get(3);
            BooleanLiteral showOverflowEntryCount = (BooleanLiteral)arguments.get(4);
            Object innerArguments = this.joinExpressions((List<Expression>)ImmutableList.of((Object)expression, (Object)separator));
            if (node.isDistinct()) {
                innerArguments = "DISTINCT " + (String)innerArguments;
            }
            builder.append("LISTAGG").append('(').append((String)innerArguments);
            builder.append(" ON OVERFLOW ");
            if (overflowError.getValue()) {
                builder.append(" ERROR");
            } else {
                builder.append(" TRUNCATE").append(' ').append((String)this.process(overflowFiller, null));
                if (showOverflowEntryCount.getValue()) {
                    builder.append(" WITH COUNT");
                } else {
                    builder.append(" WITHOUT COUNT");
                }
            }
            builder.append(')');
            if (node.getOrderBy().isPresent()) {
                builder.append(" WITHIN GROUP ").append('(').append(ExpressionFormatter.formatOrderBy(node.getOrderBy().get())).append(')');
            }
            if (node.getFilter().isPresent()) {
                builder.append(" FILTER ").append(this.visitFilter(node.getFilter().get(), null));
            }
            return builder.toString();
        }
    }
}

