/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.GrantObject;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowGrants
extends Statement {
    private final Optional<GrantObject> grantObject;

    public ShowGrants(Optional<GrantObject> grantObject) {
        this(Optional.empty(), grantObject);
    }

    public ShowGrants(NodeLocation location, Optional<GrantObject> grantObject) {
        this(Optional.of(location), grantObject);
    }

    public ShowGrants(Optional<NodeLocation> location, Optional<GrantObject> grantObject) {
        super(location);
        this.grantObject = grantObject == null ? Optional.empty() : grantObject;
    }

    public Optional<String> getEntityKind() {
        return this.grantObject.flatMap(scope -> scope.getEntityKind());
    }

    public Optional<GrantObject> getGrantObject() {
        return this.grantObject;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowGrants(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return this.grantObject.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowGrants o = (ShowGrants)obj;
        return Objects.equals(this.grantObject, o.grantObject);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("grantScope", this.grantObject).toString();
    }
}

