/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableSet;
import io.trino.grammar.sql.SqlKeywords;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.Identifier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ReservedIdentifiers {
    private static final Pattern TABLE_ROW = Pattern.compile("\\| `([A-Z_]+)`.*");
    private static final String TABLE_START = "| ------------------- |";
    private static final String TABLE_ROW_START = "|";
    private static final SqlParser PARSER = new SqlParser();

    private ReservedIdentifiers() {
    }

    public static void main(String[] args) {
        if (args.length == 2 && args[0].equals("validateDocs")) {
            try {
                ReservedIdentifiers.validateDocs(Paths.get(args[1], new String[0]));
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(100);
            }
        } else {
            for (String name : ReservedIdentifiers.reservedIdentifiers()) {
                System.out.println(name);
            }
        }
    }

    private static void validateDocs(Path path) throws IOException {
        String line;
        System.out.println("Validating " + String.valueOf(path));
        List<String> lines = Files.readAllLines(path);
        if (lines.stream().filter(s -> s.startsWith(TABLE_START)).count() != 1L) {
            throw new RuntimeException("Failed to find exactly one table");
        }
        Iterator<String> iterator = lines.iterator();
        while (!iterator.next().startsWith(TABLE_START)) {
        }
        Set<String> reserved = ReservedIdentifiers.reservedIdentifiers();
        HashSet<String> found = new HashSet<String>();
        while ((line = iterator.next()).startsWith(TABLE_ROW_START)) {
            Matcher matcher = TABLE_ROW.matcher(line);
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid table line: " + line);
            }
            String name = matcher.group(1);
            if (!reserved.contains(name)) {
                throw new RuntimeException("Documented identifier is not reserved: " + name);
            }
            if (found.add(name)) continue;
            throw new RuntimeException("Duplicate documented identifier: " + name);
        }
        for (String name : reserved) {
            if (found.contains(name)) continue;
            throw new RuntimeException("Reserved identifier is not documented: " + name);
        }
        System.out.println("Validated %s reserved identifiers".formatted(reserved.size()));
    }

    public static Set<String> reservedIdentifiers() {
        return (Set)SqlKeywords.sqlKeywords().stream().filter(ReservedIdentifiers::reserved).sorted().collect(ImmutableSet.toImmutableSet());
    }

    public static boolean reserved(String name) {
        try {
            return !(PARSER.createExpression(name) instanceof Identifier);
        }
        catch (ParsingException ignored) {
            return true;
        }
    }
}

