/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class VariableDeclaration
extends ControlStatement {
    private final List<Identifier> names;
    private final DataType type;
    private final Optional<Expression> defaultValue;

    public VariableDeclaration(NodeLocation location, List<Identifier> names, DataType type, Optional<Expression> defaultValue) {
        super(location);
        this.names = Objects.requireNonNull(names, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
    }

    public List<Identifier> getNames() {
        return this.names;
    }

    public DataType getType() {
        return this.type;
    }

    public Optional<Expression> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitVariableDeclaration(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return (List)this.defaultValue.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof VariableDeclaration)) return false;
        VariableDeclaration other = (VariableDeclaration)obj;
        if (!Objects.equals(this.names, other.names)) return false;
        if (!Objects.equals(this.type, other.type)) return false;
        if (!Objects.equals(this.defaultValue, other.defaultValue)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.names, this.type, this.defaultValue);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("names", this.names).add("type", (Object)this.type).add("defaultValue", this.defaultValue).toString();
    }
}

