/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PatternQuantifier;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RangeQuantifier
extends PatternQuantifier {
    private final Optional<LongLiteral> atLeast;
    private final Optional<LongLiteral> atMost;

    public RangeQuantifier(boolean greedy, Optional<LongLiteral> atLeast, Optional<LongLiteral> atMost) {
        this(Optional.empty(), greedy, atLeast, atMost);
    }

    public RangeQuantifier(NodeLocation location, boolean greedy, Optional<LongLiteral> atLeast, Optional<LongLiteral> atMost) {
        this(Optional.of(location), greedy, atLeast, atMost);
    }

    private RangeQuantifier(Optional<NodeLocation> location, boolean greedy, Optional<LongLiteral> atLeast, Optional<LongLiteral> atMost) {
        super(location, greedy);
        this.atLeast = Objects.requireNonNull(atLeast, "atLeast is null");
        this.atMost = Objects.requireNonNull(atMost, "atMost is null");
    }

    public Optional<LongLiteral> getAtLeast() {
        return this.atLeast;
    }

    public Optional<LongLiteral> getAtMost() {
        return this.atMost;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRangeQuantifier(this, context);
    }

    @Override
    public List<Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        this.atLeast.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        this.atMost.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RangeQuantifier o = (RangeQuantifier)obj;
        return this.isGreedy() == o.isGreedy() && Objects.equals(this.atLeast, o.atLeast) && Objects.equals(this.atMost, o.atMost);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isGreedy(), this.atLeast, this.atMost);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("atLeast", this.atLeast).add("atMost", this.atMost).add("greedy", this.isGreedy()).toString();
    }
}

