/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.GrantOnType;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Deny
extends Statement {
    private final Optional<List<String>> privileges;
    private final Optional<GrantOnType> type;
    private final QualifiedName name;
    private final PrincipalSpecification grantee;

    public Deny(Optional<List<String>> privileges, Optional<GrantOnType> type, QualifiedName name, PrincipalSpecification grantee) {
        this(Optional.empty(), privileges, type, name, grantee);
    }

    public Deny(NodeLocation location, Optional<List<String>> privileges, Optional<GrantOnType> type, QualifiedName name, PrincipalSpecification grantee) {
        this(Optional.of(location), privileges, type, name, grantee);
    }

    private Deny(Optional<NodeLocation> location, Optional<List<String>> privileges, Optional<GrantOnType> type, QualifiedName name, PrincipalSpecification grantee) {
        super(location);
        Objects.requireNonNull(privileges, "privileges is null");
        this.privileges = privileges.map(ImmutableList::copyOf);
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
    }

    public Optional<List<String>> getPrivileges() {
        return this.privileges;
    }

    public Optional<GrantOnType> getType() {
        return this.type;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public PrincipalSpecification getGrantee() {
        return this.grantee;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDeny(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.privileges, this.type, this.name, this.grantee);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Deny o = (Deny)obj;
        return Objects.equals(this.privileges, o.privileges) && Objects.equals(this.type, o.type) && Objects.equals(this.name, o.name) && Objects.equals(this.grantee, o.grantee);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("privileges", this.privileges).add("type", this.type).add("name", (Object)this.name).add("grantee", (Object)this.grantee).toString();
    }
}

