/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonQuery
extends Expression {
    private final JsonPathInvocation jsonPathInvocation;
    private final Optional<DataType> returnedType;
    private final Optional<JsonPathParameter.JsonFormat> outputFormat;
    private final ArrayWrapperBehavior wrapperBehavior;
    private final Optional<QuotesBehavior> quotesBehavior;
    private final EmptyOrErrorBehavior emptyBehavior;
    private final EmptyOrErrorBehavior errorBehavior;

    public JsonQuery(Optional<NodeLocation> location, JsonPathInvocation jsonPathInvocation, Optional<DataType> returnedType, Optional<JsonPathParameter.JsonFormat> outputFormat, ArrayWrapperBehavior wrapperBehavior, Optional<QuotesBehavior> quotesBehavior, EmptyOrErrorBehavior emptyBehavior, EmptyOrErrorBehavior errorBehavior) {
        super(location);
        Objects.requireNonNull(jsonPathInvocation, "jsonPathInvocation is null");
        Objects.requireNonNull(returnedType, "returnedType is null");
        Objects.requireNonNull(outputFormat, "outputFormat is null");
        Objects.requireNonNull(wrapperBehavior, "wrapperBehavior is null");
        Objects.requireNonNull(quotesBehavior, "quotesBehavior is null");
        Objects.requireNonNull(emptyBehavior, "emptyBehavior is null");
        Objects.requireNonNull(errorBehavior, "errorBehavior is null");
        this.jsonPathInvocation = jsonPathInvocation;
        this.returnedType = returnedType;
        this.outputFormat = outputFormat;
        this.wrapperBehavior = wrapperBehavior;
        this.quotesBehavior = quotesBehavior;
        this.emptyBehavior = emptyBehavior;
        this.errorBehavior = errorBehavior;
    }

    public JsonPathInvocation getJsonPathInvocation() {
        return this.jsonPathInvocation;
    }

    public Optional<DataType> getReturnedType() {
        return this.returnedType;
    }

    public Optional<JsonPathParameter.JsonFormat> getOutputFormat() {
        return this.outputFormat;
    }

    public ArrayWrapperBehavior getWrapperBehavior() {
        return this.wrapperBehavior;
    }

    public Optional<QuotesBehavior> getQuotesBehavior() {
        return this.quotesBehavior;
    }

    public EmptyOrErrorBehavior getEmptyBehavior() {
        return this.emptyBehavior;
    }

    public EmptyOrErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonQuery(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.jsonPathInvocation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonQuery that = (JsonQuery)o;
        return Objects.equals(this.jsonPathInvocation, that.jsonPathInvocation) && Objects.equals(this.returnedType, that.returnedType) && Objects.equals(this.outputFormat, that.outputFormat) && this.wrapperBehavior == that.wrapperBehavior && Objects.equals(this.quotesBehavior, that.quotesBehavior) && this.emptyBehavior == that.emptyBehavior && this.errorBehavior == that.errorBehavior;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonPathInvocation, this.returnedType, this.outputFormat, this.wrapperBehavior, this.quotesBehavior, this.emptyBehavior, this.errorBehavior});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonQuery.sameClass(this, other)) {
            return false;
        }
        JsonQuery otherJsonQuery = (JsonQuery)other;
        return this.returnedType.equals(otherJsonQuery.returnedType) && this.outputFormat.equals(otherJsonQuery.outputFormat) && this.wrapperBehavior == otherJsonQuery.wrapperBehavior && Objects.equals(this.quotesBehavior, otherJsonQuery.quotesBehavior) && this.emptyBehavior == otherJsonQuery.emptyBehavior && this.errorBehavior == otherJsonQuery.errorBehavior;
    }

    public static enum ArrayWrapperBehavior {
        WITHOUT,
        CONDITIONAL,
        UNCONDITIONAL;

    }

    public static enum EmptyOrErrorBehavior {
        NULL("NULL"),
        ERROR("ERROR"),
        EMPTY_ARRAY("EMPTY ARRAY"),
        EMPTY_OBJECT("EMPTY OBJECT");

        private final String label;

        private EmptyOrErrorBehavior(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum QuotesBehavior {
        KEEP,
        OMIT;

    }
}

