/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Cube;
import io.trino.sql.tree.DefaultTraversalVisitor;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GroupingElement;
import io.trino.sql.tree.GroupingSets;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.Rollup;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SimpleGroupBy;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.WindowDefinition;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import java.io.PrintStream;
import java.util.IdentityHashMap;
import java.util.List;

public class TreePrinter {
    private static final String INDENT = "   ";
    private final IdentityHashMap<Expression, QualifiedName> resolvedNameReferences;
    private final PrintStream out;

    public TreePrinter(IdentityHashMap<Expression, QualifiedName> resolvedNameReferences, PrintStream out) {
        this.resolvedNameReferences = new IdentityHashMap<Expression, QualifiedName>(resolvedNameReferences);
        this.out = out;
    }

    public void print(Node root) {
        DefaultTraversalVisitor<Integer> printer = new DefaultTraversalVisitor<Integer>(){

            @Override
            protected Void visitNode(Node node, Integer indentLevel) {
                throw new UnsupportedOperationException("not yet implemented: " + node);
            }

            @Override
            protected Void visitQuery(Query node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Query ");
                Integer n = indentLevel;
                indentLevel = indentLevel + 1;
                TreePrinter.this.print(indentLevel, "QueryBody");
                this.process(node.getQueryBody(), indentLevel);
                if (node.getOrderBy().isPresent()) {
                    TreePrinter.this.print(indentLevel, "OrderBy");
                    this.process(node.getOrderBy().get(), indentLevel + 1);
                }
                if (node.getLimit().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Limit: " + node.getLimit().get());
                }
                return null;
            }

            @Override
            protected Void visitQuerySpecification(QuerySpecification node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "QuerySpecification ");
                Integer n = indentLevel;
                indentLevel = indentLevel + 1;
                this.process(node.getSelect(), indentLevel);
                if (node.getFrom().isPresent()) {
                    TreePrinter.this.print(indentLevel, "From");
                    this.process(node.getFrom().get(), indentLevel + 1);
                }
                if (node.getWhere().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Where");
                    this.process(node.getWhere().get(), indentLevel + 1);
                }
                if (node.getGroupBy().isPresent()) {
                    String distinct = "";
                    if (node.getGroupBy().get().isDistinct()) {
                        distinct = "[DISTINCT]";
                    }
                    TreePrinter.this.print(indentLevel, "GroupBy" + distinct);
                    for (GroupingElement groupingElement : node.getGroupBy().get().getGroupingElements()) {
                        TreePrinter.this.print(indentLevel, "SimpleGroupBy");
                        if (groupingElement instanceof SimpleGroupBy) {
                            for (Expression expression : groupingElement.getExpressions()) {
                                this.process(expression, indentLevel + 1);
                            }
                            continue;
                        }
                        if (groupingElement instanceof GroupingSets) {
                            TreePrinter.this.print(indentLevel + 1, "GroupingSets");
                            for (List list : ((GroupingSets)groupingElement).getSets()) {
                                TreePrinter.this.print(indentLevel + 2, "GroupingSet[");
                                for (Expression expression : list) {
                                    this.process(expression, indentLevel + 3);
                                }
                                TreePrinter.this.print(indentLevel + 2, "]");
                            }
                            continue;
                        }
                        if (groupingElement instanceof Cube) {
                            TreePrinter.this.print(indentLevel + 1, "Cube");
                            for (Expression expression : groupingElement.getExpressions()) {
                                this.process(expression, indentLevel + 1);
                            }
                            continue;
                        }
                        if (!(groupingElement instanceof Rollup)) continue;
                        TreePrinter.this.print(indentLevel + 1, "Rollup");
                        for (Expression expression : groupingElement.getExpressions()) {
                            this.process(expression, indentLevel + 1);
                        }
                    }
                }
                if (node.getHaving().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Having");
                    this.process(node.getHaving().get(), indentLevel + 1);
                }
                if (!node.getWindows().isEmpty()) {
                    TreePrinter.this.print(indentLevel, "Window");
                    for (WindowDefinition windowDefinition : node.getWindows()) {
                        this.process(windowDefinition, indentLevel + 1);
                    }
                }
                if (node.getOrderBy().isPresent()) {
                    TreePrinter.this.print(indentLevel, "OrderBy");
                    this.process(node.getOrderBy().get(), indentLevel + 1);
                }
                if (node.getLimit().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Limit: " + node.getLimit().get());
                }
                return null;
            }

            @Override
            protected Void visitOrderBy(OrderBy node, Integer indentLevel) {
                for (SortItem sortItem : node.getSortItems()) {
                    this.process(sortItem, indentLevel);
                }
                return null;
            }

            @Override
            protected Void visitWindowDefinition(WindowDefinition node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "WindowDefinition[" + node.getName() + "]");
                this.process(node.getWindow(), indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitWindowReference(WindowReference node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "WindowReference[" + node.getName() + "]");
                return null;
            }

            @Override
            public Void visitWindowSpecification(WindowSpecification node, Integer indentLevel) {
                if (node.getExistingWindowName().isPresent()) {
                    TreePrinter.this.print(indentLevel, "ExistingWindowName " + node.getExistingWindowName().get());
                }
                if (!node.getPartitionBy().isEmpty()) {
                    TreePrinter.this.print(indentLevel, "PartitionBy");
                    for (Expression expression : node.getPartitionBy()) {
                        this.process(expression, indentLevel + 1);
                    }
                }
                if (node.getOrderBy().isPresent()) {
                    TreePrinter.this.print(indentLevel, "OrderBy");
                    this.process(node.getOrderBy().get(), indentLevel + 1);
                }
                if (node.getFrame().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Frame");
                    this.process(node.getFrame().get(), indentLevel + 1);
                }
                return null;
            }

            @Override
            protected Void visitSelect(Select node, Integer indentLevel) {
                String distinct = "";
                if (node.isDistinct()) {
                    distinct = "[DISTINCT]";
                }
                TreePrinter.this.print(indentLevel, "Select" + distinct);
                super.visitSelect(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitAllColumns(AllColumns node, Integer indent) {
                StringBuilder aliases = new StringBuilder();
                if (!node.getAliases().isEmpty()) {
                    aliases.append(" [Aliases: ");
                    Joiner.on((String)", ").appendTo(aliases, node.getAliases());
                    aliases.append("]");
                }
                TreePrinter.this.print(indent, "All columns" + aliases.toString());
                if (node.getTarget().isPresent()) {
                    super.visitAllColumns(node, (Object)(indent + 1));
                }
                return null;
            }

            @Override
            protected Void visitSingleColumn(SingleColumn node, Integer indent) {
                if (node.getAlias().isPresent()) {
                    TreePrinter.this.print(indent, "Alias: " + node.getAlias().get());
                }
                super.visitSingleColumn(node, (Object)(indent + 1));
                return null;
            }

            @Override
            protected Void visitComparisonExpression(ComparisonExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getOperator().toString());
                super.visitComparisonExpression(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitArithmeticBinary(ArithmeticBinaryExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getOperator().toString());
                super.visitArithmeticBinary(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitLogicalExpression(LogicalExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getOperator().toString());
                super.visitLogicalExpression(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitStringLiteral(StringLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "String[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitBinaryLiteral(BinaryLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Binary[" + node.toHexString() + "]");
                return null;
            }

            @Override
            protected Void visitBooleanLiteral(BooleanLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Boolean[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitLongLiteral(LongLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Long[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitLikePredicate(LikePredicate node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "LIKE");
                super.visitLikePredicate(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitIdentifier(Identifier node, Integer indentLevel) {
                QualifiedName resolved = (QualifiedName)TreePrinter.this.resolvedNameReferences.get(node);
                String resolvedName = "";
                if (resolved != null) {
                    resolvedName = "=>" + resolved.toString();
                }
                TreePrinter.this.print(indentLevel, "Identifier[" + node.getValue() + resolvedName + "]");
                return null;
            }

            @Override
            protected Void visitDereferenceExpression(DereferenceExpression node, Integer indentLevel) {
                QualifiedName resolved = (QualifiedName)TreePrinter.this.resolvedNameReferences.get(node);
                String resolvedName = "";
                if (resolved != null) {
                    resolvedName = "=>" + resolved.toString();
                }
                TreePrinter.this.print(indentLevel, "DereferenceExpression[" + node + resolvedName + "]");
                return null;
            }

            @Override
            protected Void visitFunctionCall(FunctionCall node, Integer indentLevel) {
                String name = Joiner.on((char)'.').join(node.getName().getParts());
                TreePrinter.this.print(indentLevel, "FunctionCall[" + name + "]");
                super.visitFunctionCall(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitTable(Table node, Integer indentLevel) {
                String name = Joiner.on((char)'.').join(node.getName().getParts());
                TreePrinter.this.print(indentLevel, "Table[" + name + "]");
                return null;
            }

            @Override
            protected Void visitValues(Values node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Values");
                super.visitValues(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitRow(Row node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Row");
                super.visitRow(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitAliasedRelation(AliasedRelation node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Alias[" + node.getAlias() + "]");
                super.visitAliasedRelation(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitSampledRelation(SampledRelation node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "TABLESAMPLE[" + (Object)((Object)node.getType()) + " (" + node.getSamplePercentage() + ")]");
                super.visitSampledRelation(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitTableSubquery(TableSubquery node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "SubQuery");
                super.visitTableSubquery(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitInPredicate(InPredicate node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "IN");
                super.visitInPredicate(node, (Object)(indentLevel + 1));
                return null;
            }

            @Override
            protected Void visitSubqueryExpression(SubqueryExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "SubQuery");
                super.visitSubqueryExpression(node, (Object)(indentLevel + 1));
                return null;
            }
        };
        printer.process(root, 0);
    }

    private void print(Integer indentLevel, String value) {
        this.out.println(Strings.repeat((String)INDENT, (int)indentLevel) + value);
    }
}

