/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LabelDereference
extends Expression {
    private final String label;
    private final SymbolReference reference;

    public LabelDereference(String label, SymbolReference reference) {
        super(Optional.empty());
        this.label = Objects.requireNonNull(label, "label is null");
        this.reference = Objects.requireNonNull(reference, "reference is null");
    }

    public String getLabel() {
        return this.label;
    }

    public SymbolReference getReference() {
        return this.reference;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLabelDereference(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.reference);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelDereference that = (LabelDereference)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.reference, that.reference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.label, this.reference);
    }
}

