/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;

public record MemorySplit(long table, int partNumber, int totalPartsPerWorker, HostAddress address, long expectedRows, OptionalLong limit) implements ConnectorSplit
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MemorySplit.class);

    public MemorySplit(long table, int partNumber, int totalPartsPerWorker, HostAddress address, long expectedRows, OptionalLong limit) {
        Preconditions.checkState((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Preconditions.checkState((totalPartsPerWorker >= 1 ? 1 : 0) != 0, (Object)"totalPartsPerWorker must be >= 1");
        Preconditions.checkState((totalPartsPerWorker > partNumber ? 1 : 0) != 0, (Object)"totalPartsPerWorker must be > partNumber");
        this.table = table;
        this.partNumber = partNumber;
        this.totalPartsPerWorker = totalPartsPerWorker;
        this.address = Objects.requireNonNull(address, "address is null");
        this.expectedRows = expectedRows;
        this.limit = limit;
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.of((Object)"table", (Object)String.valueOf(this.table), (Object)"partNumber", (Object)String.valueOf(this.partNumber), (Object)"address", (Object)this.address.toString());
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.address.getRetainedSizeInBytes() + SizeOf.sizeOf((OptionalLong)this.limit);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)this.address);
    }
}

